/*
 * Decompiled with CFR 0.152.
 */
package de.mklinger.qetcher.client.httpclient.internal;

import de.mklinger.qetcher.client.httpclient.HttpResponse;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.concurrent.CompletableFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileCompleteListener
implements HttpResponse.BodyCompleteListener<Path> {
    private static final Logger LOG = LoggerFactory.getLogger(FileCompleteListener.class);
    private final Path targetFile;
    private final OpenOption[] openOptions;
    private volatile SeekableByteChannel channel;
    private final CompletableFuture<Path> result;

    public FileCompleteListener(Path targetFile, OpenOption ... openOptions) {
        this.targetFile = targetFile;
        this.openOptions = openOptions;
        this.result = new CompletableFuture();
    }

    public CompletableFuture<Path> getResult() {
        return this.result;
    }

    @Override
    public void onNext(ByteBuffer content) throws IOException {
        if (this.channel == null) {
            this.channel = Files.newByteChannel(this.targetFile, this.openOptions);
        }
        LOG.debug("Writing {} bytes", (Object)content.remaining());
        this.channel.write(content);
    }

    @Override
    public void onComplete() throws Exception {
        this.close();
    }

    @Override
    public Path getBody() throws Exception {
        return this.targetFile;
    }

    @Override
    public void close() throws Exception {
        SeekableByteChannel c = this.channel;
        this.channel = null;
        if (c != null) {
            c.close();
        }
    }
}

