/*
 * Decompiled with CFR 0.152.
 */
package de.mklinger.qetcher.client.deps.jetty.io;

import de.mklinger.qetcher.client.deps.jetty.io.AbstractConnection;
import de.mklinger.qetcher.client.deps.jetty.io.ClientConnectionFactory;
import de.mklinger.qetcher.client.deps.jetty.io.EndPoint;
import de.mklinger.qetcher.client.deps.jetty.io.RuntimeIOException;
import de.mklinger.qetcher.client.deps.jetty.util.BufferUtil;
import de.mklinger.qetcher.client.deps.jetty.util.log.Log;
import de.mklinger.qetcher.client.deps.jetty.util.log.Logger;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.Executor;
import javax.net.ssl.SSLEngine;

public abstract class NegotiatingClientConnection
extends AbstractConnection {
    private static final Logger LOG = Log.getLogger(NegotiatingClientConnection.class);
    private final SSLEngine engine;
    private final ClientConnectionFactory connectionFactory;
    private final Map<String, Object> context;
    private volatile boolean completed;

    protected NegotiatingClientConnection(EndPoint endp, Executor executor, SSLEngine sslEngine, ClientConnectionFactory connectionFactory, Map<String, Object> context) {
        super(endp, executor);
        this.engine = sslEngine;
        this.connectionFactory = connectionFactory;
        this.context = context;
    }

    public SSLEngine getSSLEngine() {
        return this.engine;
    }

    protected void completed() {
        this.completed = true;
    }

    @Override
    public void onOpen() {
        super.onOpen();
        try {
            this.getEndPoint().flush(BufferUtil.EMPTY_BUFFER);
            if (this.completed) {
                this.replaceConnection();
            } else {
                this.fillInterested();
            }
        }
        catch (IOException x) {
            this.close();
            throw new RuntimeIOException(x);
        }
    }

    @Override
    public void onFillable() {
        block1: {
            int filled;
            do {
                filled = this.fill();
                if (!this.completed && filled >= 0) continue;
                this.replaceConnection();
                break block1;
            } while (filled != 0);
            this.fillInterested();
        }
    }

    private int fill() {
        try {
            return this.getEndPoint().fill(BufferUtil.EMPTY_BUFFER);
        }
        catch (IOException x) {
            LOG.debug(x);
            this.close();
            return -1;
        }
    }

    private void replaceConnection() {
        EndPoint endPoint = this.getEndPoint();
        try {
            endPoint.upgrade(this.connectionFactory.newConnection(endPoint, this.context));
        }
        catch (Throwable x) {
            LOG.debug(x);
            this.close();
        }
    }

    @Override
    public void close() {
        this.getEndPoint().shutdownOutput();
        super.close();
    }
}

