/*
 * Decompiled with CFR 0.152.
 */
package de.mklinger.qetcher.client.deps.jetty.http2.parser;

import de.mklinger.qetcher.client.deps.jetty.http2.ErrorCode;
import de.mklinger.qetcher.client.deps.jetty.http2.frames.SettingsFrame;
import de.mklinger.qetcher.client.deps.jetty.http2.parser.BodyParser;
import de.mklinger.qetcher.client.deps.jetty.http2.parser.HeaderParser;
import de.mklinger.qetcher.client.deps.jetty.http2.parser.Parser;
import de.mklinger.qetcher.client.deps.jetty.util.log.Log;
import de.mklinger.qetcher.client.deps.jetty.util.log.Logger;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;

public class SettingsBodyParser
extends BodyParser {
    private static final Logger LOG = Log.getLogger(SettingsBodyParser.class);
    private State state = State.PREPARE;
    private int cursor;
    private int length;
    private int settingId;
    private int settingValue;
    private Map<Integer, Integer> settings;

    public SettingsBodyParser(HeaderParser headerParser, Parser.Listener listener) {
        super(headerParser, listener);
    }

    protected void reset() {
        this.state = State.PREPARE;
        this.cursor = 0;
        this.length = 0;
        this.settingId = 0;
        this.settingValue = 0;
        this.settings = null;
    }

    @Override
    protected void emptyBody(ByteBuffer buffer) {
        this.onSettings(new HashMap<Integer, Integer>());
    }

    @Override
    public boolean parse(ByteBuffer buffer) {
        block7: while (buffer.hasRemaining()) {
            switch (this.state) {
                case PREPARE: {
                    if (this.getStreamId() != 0) {
                        return this.connectionFailure(buffer, ErrorCode.PROTOCOL_ERROR.code, "invalid_settings_frame");
                    }
                    this.length = this.getBodyLength();
                    this.settings = new HashMap<Integer, Integer>();
                    this.state = State.SETTING_ID;
                    continue block7;
                }
                case SETTING_ID: {
                    if (buffer.remaining() >= 2) {
                        this.settingId = buffer.getShort() & 0xFFFF;
                        this.state = State.SETTING_VALUE;
                        this.length -= 2;
                        if (this.length > 0) continue block7;
                        return this.connectionFailure(buffer, ErrorCode.FRAME_SIZE_ERROR.code, "invalid_settings_frame");
                    }
                    this.cursor = 2;
                    this.settingId = 0;
                    this.state = State.SETTING_ID_BYTES;
                    continue block7;
                }
                case SETTING_ID_BYTES: {
                    int currByte = buffer.get() & 0xFF;
                    --this.cursor;
                    this.settingId += currByte << 8 * this.cursor;
                    --this.length;
                    if (this.length <= 0) {
                        return this.connectionFailure(buffer, ErrorCode.FRAME_SIZE_ERROR.code, "invalid_settings_frame");
                    }
                    if (this.cursor != 0) continue block7;
                    this.state = State.SETTING_VALUE;
                    continue block7;
                }
                case SETTING_VALUE: {
                    if (buffer.remaining() >= 4) {
                        this.settingValue = buffer.getInt();
                        if (LOG.isDebugEnabled()) {
                            LOG.debug(String.format("setting %d=%d", this.settingId, this.settingValue), new Object[0]);
                        }
                        this.settings.put(this.settingId, this.settingValue);
                        this.state = State.SETTING_ID;
                        this.length -= 4;
                        if (this.length != 0) continue block7;
                        return this.onSettings(this.settings);
                    }
                    this.cursor = 4;
                    this.settingValue = 0;
                    this.state = State.SETTING_VALUE_BYTES;
                    continue block7;
                }
                case SETTING_VALUE_BYTES: {
                    int currByte = buffer.get() & 0xFF;
                    --this.cursor;
                    this.settingValue += currByte << 8 * this.cursor;
                    --this.length;
                    if (this.cursor > 0 && this.length <= 0) {
                        return this.connectionFailure(buffer, ErrorCode.FRAME_SIZE_ERROR.code, "invalid_settings_frame");
                    }
                    if (this.cursor != 0) continue block7;
                    if (LOG.isDebugEnabled()) {
                        LOG.debug(String.format("setting %d=%d", this.settingId, this.settingValue), new Object[0]);
                    }
                    this.settings.put(this.settingId, this.settingValue);
                    this.state = State.SETTING_ID;
                    if (this.length != 0) continue block7;
                    return this.onSettings(this.settings);
                }
            }
            throw new IllegalStateException();
        }
        return false;
    }

    protected boolean onSettings(Map<Integer, Integer> settings) {
        SettingsFrame frame = new SettingsFrame(settings, this.hasFlag(1));
        this.reset();
        this.notifySettings(frame);
        return true;
    }

    public static SettingsFrame parseBody(ByteBuffer buffer) {
        final int bodyLength = buffer.remaining();
        final AtomicReference frameRef = new AtomicReference();
        SettingsBodyParser parser = new SettingsBodyParser(null, null){

            @Override
            protected int getStreamId() {
                return 0;
            }

            @Override
            protected int getBodyLength() {
                return bodyLength;
            }

            @Override
            protected boolean onSettings(Map<Integer, Integer> settings) {
                frameRef.set(new SettingsFrame(settings, false));
                return true;
            }

            @Override
            protected boolean connectionFailure(ByteBuffer buffer, int error, String reason) {
                frameRef.set(null);
                return false;
            }
        };
        if (bodyLength == 0) {
            parser.emptyBody(buffer);
        } else {
            parser.parse(buffer);
        }
        return (SettingsFrame)frameRef.get();
    }

    private static enum State {
        PREPARE,
        SETTING_ID,
        SETTING_ID_BYTES,
        SETTING_VALUE,
        SETTING_VALUE_BYTES;

    }
}

