/*
 * Decompiled with CFR 0.152.
 */
package de.mklinger.qetcher.client.deps.jetty.http2.parser;

import de.mklinger.qetcher.client.deps.jetty.http2.ErrorCode;
import de.mklinger.qetcher.client.deps.jetty.http2.frames.DataFrame;
import de.mklinger.qetcher.client.deps.jetty.http2.frames.GoAwayFrame;
import de.mklinger.qetcher.client.deps.jetty.http2.frames.HeadersFrame;
import de.mklinger.qetcher.client.deps.jetty.http2.frames.PingFrame;
import de.mklinger.qetcher.client.deps.jetty.http2.frames.PriorityFrame;
import de.mklinger.qetcher.client.deps.jetty.http2.frames.PushPromiseFrame;
import de.mklinger.qetcher.client.deps.jetty.http2.frames.ResetFrame;
import de.mklinger.qetcher.client.deps.jetty.http2.frames.SettingsFrame;
import de.mklinger.qetcher.client.deps.jetty.http2.frames.WindowUpdateFrame;
import de.mklinger.qetcher.client.deps.jetty.http2.parser.HeaderParser;
import de.mklinger.qetcher.client.deps.jetty.http2.parser.Parser;
import de.mklinger.qetcher.client.deps.jetty.util.BufferUtil;
import de.mklinger.qetcher.client.deps.jetty.util.log.Log;
import de.mklinger.qetcher.client.deps.jetty.util.log.Logger;
import java.nio.ByteBuffer;

public abstract class BodyParser {
    protected static final Logger LOG = Log.getLogger(BodyParser.class);
    private final HeaderParser headerParser;
    private final Parser.Listener listener;

    protected BodyParser(HeaderParser headerParser, Parser.Listener listener) {
        this.headerParser = headerParser;
        this.listener = listener;
    }

    public abstract boolean parse(ByteBuffer var1);

    protected void emptyBody(ByteBuffer buffer) {
        this.connectionFailure(buffer, ErrorCode.PROTOCOL_ERROR.code, "invalid_frame");
    }

    protected boolean hasFlag(int bit) {
        return this.headerParser.hasFlag(bit);
    }

    protected boolean isPadding() {
        return this.headerParser.hasFlag(8);
    }

    protected boolean isEndStream() {
        return this.headerParser.hasFlag(1);
    }

    protected int getStreamId() {
        return this.headerParser.getStreamId();
    }

    protected int getBodyLength() {
        return this.headerParser.getLength();
    }

    protected void notifyData(DataFrame frame) {
        try {
            this.listener.onData(frame);
        }
        catch (Throwable x) {
            LOG.info("Failure while notifying listener " + this.listener, x);
        }
    }

    protected void notifyHeaders(HeadersFrame frame) {
        try {
            this.listener.onHeaders(frame);
        }
        catch (Throwable x) {
            LOG.info("Failure while notifying listener " + this.listener, x);
        }
    }

    protected void notifyPriority(PriorityFrame frame) {
        try {
            this.listener.onPriority(frame);
        }
        catch (Throwable x) {
            LOG.info("Failure while notifying listener " + this.listener, x);
        }
    }

    protected void notifyReset(ResetFrame frame) {
        try {
            this.listener.onReset(frame);
        }
        catch (Throwable x) {
            LOG.info("Failure while notifying listener " + this.listener, x);
        }
    }

    protected void notifySettings(SettingsFrame frame) {
        try {
            this.listener.onSettings(frame);
        }
        catch (Throwable x) {
            LOG.info("Failure while notifying listener " + this.listener, x);
        }
    }

    protected void notifyPushPromise(PushPromiseFrame frame) {
        try {
            this.listener.onPushPromise(frame);
        }
        catch (Throwable x) {
            LOG.info("Failure while notifying listener " + this.listener, x);
        }
    }

    protected void notifyPing(PingFrame frame) {
        try {
            this.listener.onPing(frame);
        }
        catch (Throwable x) {
            LOG.info("Failure while notifying listener " + this.listener, x);
        }
    }

    protected void notifyGoAway(GoAwayFrame frame) {
        try {
            this.listener.onGoAway(frame);
        }
        catch (Throwable x) {
            LOG.info("Failure while notifying listener " + this.listener, x);
        }
    }

    protected void notifyWindowUpdate(WindowUpdateFrame frame) {
        try {
            this.listener.onWindowUpdate(frame);
        }
        catch (Throwable x) {
            LOG.info("Failure while notifying listener " + this.listener, x);
        }
    }

    protected boolean connectionFailure(ByteBuffer buffer, int error, String reason) {
        BufferUtil.clear(buffer);
        this.notifyConnectionFailure(error, reason);
        return false;
    }

    private void notifyConnectionFailure(int error, String reason) {
        try {
            this.listener.onConnectionFailure(error, reason);
        }
        catch (Throwable x) {
            LOG.info("Failure while notifying listener " + this.listener, x);
        }
    }
}

