/*
 * Decompiled with CFR 0.152.
 */
package de.mklinger.qetcher.client.deps.jetty.http2.generator;

import de.mklinger.qetcher.client.deps.jetty.http.MetaData;
import de.mklinger.qetcher.client.deps.jetty.http2.frames.Frame;
import de.mklinger.qetcher.client.deps.jetty.http2.frames.FrameType;
import de.mklinger.qetcher.client.deps.jetty.http2.frames.PushPromiseFrame;
import de.mklinger.qetcher.client.deps.jetty.http2.generator.FrameGenerator;
import de.mklinger.qetcher.client.deps.jetty.http2.generator.HeaderGenerator;
import de.mklinger.qetcher.client.deps.jetty.http2.hpack.HpackEncoder;
import de.mklinger.qetcher.client.deps.jetty.io.ByteBufferPool;
import de.mklinger.qetcher.client.deps.jetty.util.BufferUtil;
import java.nio.ByteBuffer;

public class PushPromiseGenerator
extends FrameGenerator {
    private final HpackEncoder encoder;

    public PushPromiseGenerator(HeaderGenerator headerGenerator, HpackEncoder encoder) {
        super(headerGenerator);
        this.encoder = encoder;
    }

    @Override
    public int generate(ByteBufferPool.Lease lease, Frame frame) {
        PushPromiseFrame pushPromiseFrame = (PushPromiseFrame)frame;
        return this.generatePushPromise(lease, pushPromiseFrame.getStreamId(), pushPromiseFrame.getPromisedStreamId(), pushPromiseFrame.getMetaData());
    }

    public int generatePushPromise(ByteBufferPool.Lease lease, int streamId, int promisedStreamId, MetaData metaData) {
        if (streamId < 0) {
            throw new IllegalArgumentException("Invalid stream id: " + streamId);
        }
        if (promisedStreamId < 0) {
            throw new IllegalArgumentException("Invalid promised stream id: " + promisedStreamId);
        }
        int maxFrameSize = this.getMaxFrameSize();
        int extraSpace = 4;
        ByteBuffer hpacked = lease.acquire(maxFrameSize -= extraSpace, false);
        BufferUtil.clearToFill(hpacked);
        this.encoder.encode(hpacked, metaData);
        int hpackedLength = hpacked.position();
        BufferUtil.flipToFlush(hpacked, 0);
        int length = hpackedLength + extraSpace;
        int flags = 4;
        ByteBuffer header = this.generateHeader(lease, FrameType.PUSH_PROMISE, length, flags, streamId);
        header.putInt(promisedStreamId);
        BufferUtil.flipToFlush(header, 0);
        lease.append(header, true);
        lease.append(hpacked, true);
        return 9 + length;
    }
}

