/*
 * Decompiled with CFR 0.152.
 */
package de.mklinger.qetcher.client.deps.jetty.http2.client.http;

import de.mklinger.qetcher.client.deps.jetty.client.HttpChannel;
import de.mklinger.qetcher.client.deps.jetty.client.HttpDestination;
import de.mklinger.qetcher.client.deps.jetty.client.HttpExchange;
import de.mklinger.qetcher.client.deps.jetty.client.HttpReceiver;
import de.mklinger.qetcher.client.deps.jetty.client.HttpSender;
import de.mklinger.qetcher.client.deps.jetty.client.api.Result;
import de.mklinger.qetcher.client.deps.jetty.http2.ErrorCode;
import de.mklinger.qetcher.client.deps.jetty.http2.api.Session;
import de.mklinger.qetcher.client.deps.jetty.http2.api.Stream;
import de.mklinger.qetcher.client.deps.jetty.http2.client.http.HttpConnectionOverHTTP2;
import de.mklinger.qetcher.client.deps.jetty.http2.client.http.HttpReceiverOverHTTP2;
import de.mklinger.qetcher.client.deps.jetty.http2.client.http.HttpSenderOverHTTP2;
import de.mklinger.qetcher.client.deps.jetty.http2.frames.ResetFrame;
import de.mklinger.qetcher.client.deps.jetty.util.Callback;

public class HttpChannelOverHTTP2
extends HttpChannel {
    private final HttpConnectionOverHTTP2 connection;
    private final Session session;
    private final HttpSenderOverHTTP2 sender;
    private final HttpReceiverOverHTTP2 receiver;
    private Stream stream;

    public HttpChannelOverHTTP2(HttpDestination destination, HttpConnectionOverHTTP2 connection, Session session) {
        super(destination);
        this.connection = connection;
        this.session = session;
        this.sender = new HttpSenderOverHTTP2(this);
        this.receiver = new HttpReceiverOverHTTP2(this);
    }

    protected HttpConnectionOverHTTP2 getHttpConnection() {
        return this.connection;
    }

    public Session getSession() {
        return this.session;
    }

    public Stream.Listener getStreamListener() {
        return this.receiver;
    }

    @Override
    protected HttpSender getHttpSender() {
        return this.sender;
    }

    @Override
    protected HttpReceiver getHttpReceiver() {
        return this.receiver;
    }

    public Stream getStream() {
        return this.stream;
    }

    public void setStream(Stream stream) {
        this.stream = stream;
    }

    public boolean isFailed() {
        return this.sender.isFailed() || this.receiver.isFailed();
    }

    @Override
    public void send(HttpExchange exchange) {
        this.sender.send(exchange);
    }

    @Override
    public void release() {
        this.connection.release(this);
    }

    @Override
    public boolean abort(HttpExchange exchange, Throwable requestFailure, Throwable responseFailure) {
        Stream stream = this.getStream();
        boolean aborted = super.abort(exchange, requestFailure, responseFailure);
        if (aborted && stream != null) {
            stream.reset(new ResetFrame(stream.getId(), ErrorCode.CANCEL_STREAM_ERROR.code), Callback.NOOP);
        }
        return aborted;
    }

    @Override
    public void exchangeTerminated(HttpExchange exchange, Result result) {
        super.exchangeTerminated(exchange, result);
        this.release();
    }

    @Override
    public String toString() {
        return String.format("%s[send=%s,recv=%s]", super.toString(), this.sender, this.receiver);
    }
}

