/*
 * Decompiled with CFR 0.152.
 */
package de.mklinger.qetcher.client.deps.jetty.alpn.conscrypt.client;

import de.mklinger.qetcher.client.deps.jetty.alpn.client.ALPNClientConnection;
import de.mklinger.qetcher.client.deps.jetty.io.Connection;
import de.mklinger.qetcher.client.deps.jetty.io.ssl.ALPNProcessor;
import de.mklinger.qetcher.client.deps.jetty.io.ssl.SslConnection;
import de.mklinger.qetcher.client.deps.jetty.io.ssl.SslHandshakeListener;
import de.mklinger.qetcher.client.deps.jetty.util.log.Log;
import de.mklinger.qetcher.client.deps.jetty.util.log.Logger;
import java.lang.reflect.Method;
import java.security.Security;
import javax.net.ssl.SSLEngine;
import org.conscrypt.OpenSSLProvider;

public class ConscryptClientALPNProcessor
implements ALPNProcessor.Client {
    private static final Logger LOG = Log.getLogger(ConscryptClientALPNProcessor.class);

    @Override
    public void init() {
        if (Security.getProvider("Conscrypt") == null) {
            Security.addProvider(new OpenSSLProvider());
            if (LOG.isDebugEnabled()) {
                LOG.debug("Added Conscrypt provider", new Object[0]);
            }
        }
    }

    @Override
    public boolean appliesTo(SSLEngine sslEngine) {
        return sslEngine.getClass().getName().startsWith("org.conscrypt.");
    }

    @Override
    public void configure(SSLEngine sslEngine, Connection connection) {
        try {
            Method setAlpnProtocols = sslEngine.getClass().getDeclaredMethod("setApplicationProtocols", String[].class);
            setAlpnProtocols.setAccessible(true);
            ALPNClientConnection alpn = (ALPNClientConnection)connection;
            String[] protocols = alpn.getProtocols().toArray(new String[0]);
            setAlpnProtocols.invoke((Object)sslEngine, new Object[]{protocols});
            ((SslConnection.DecryptedEndPoint)connection.getEndPoint()).getSslConnection().addHandshakeListener(new ALPNListener(alpn));
        }
        catch (RuntimeException x) {
            throw x;
        }
        catch (Exception x) {
            throw new RuntimeException(x);
        }
    }

    private final class ALPNListener
    implements SslHandshakeListener {
        private final ALPNClientConnection alpnConnection;

        private ALPNListener(ALPNClientConnection connection) {
            this.alpnConnection = connection;
        }

        @Override
        public void handshakeSucceeded(SslHandshakeListener.Event event) {
            try {
                SSLEngine sslEngine = this.alpnConnection.getSSLEngine();
                Method method = sslEngine.getClass().getDeclaredMethod("getApplicationProtocol", new Class[0]);
                method.setAccessible(true);
                String protocol = (String)method.invoke((Object)sslEngine, new Object[0]);
                this.alpnConnection.selected(protocol);
            }
            catch (Throwable e) {
                this.alpnConnection.selected(null);
                LOG.warn(e);
            }
        }
    }
}

