/*
 * Decompiled with CFR 0.152.
 */
package de.mklinger.qetcher.client.common;

import de.mklinger.qetcher.client.common.Sets;
import de.mklinger.qetcher.client.common.UncheckedURISyntaxException;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.StringTokenizer;

public class UriBuilder {
    private static final String UTF_8 = "UTF-8";
    private static final String ADDITIONAL_ALLOWED_FRAGMENT_CHARACTERS = "!$&'()*+,;=_~:@/?";
    private String scheme;
    private String fragment;
    private String userInfo;
    private String host;
    private int port = -1;
    private String path;
    private boolean absolutePath = true;
    private List<String> pathComponents;
    private String query;
    private List<QueryParameter> queryParameters;

    public static UriBuilder of(URI url) {
        return new UriBuilder(url.getScheme(), url.getRawUserInfo(), url.getHost(), url.getPort(), url.getRawPath(), url.getRawQuery(), url.getRawFragment());
    }

    public static UriBuilder of(URL url) {
        Objects.requireNonNull(url);
        try {
            return UriBuilder.of(url.toURI());
        }
        catch (URISyntaxException e) {
            throw new UncheckedURISyntaxException(e);
        }
    }

    public static UriBuilder of(String url) {
        UriBuilder.requireText(url);
        try {
            return UriBuilder.of(new URI(url.trim()));
        }
        catch (URISyntaxException e) {
            throw new UncheckedURISyntaxException(e);
        }
    }

    private UriBuilder(String scheme, String userInfo, String host, int port, String path, String query, String fragment) {
        this.scheme(scheme);
        this.rawUserInfo(userInfo);
        this.host(host);
        this.port(port);
        this.rawPath(path);
        this.rawQuery(query);
        this.rawFragment(fragment);
    }

    private static String emptyToNull(String s) {
        if (s != null && s.isEmpty()) {
            return null;
        }
        return s;
    }

    public UriBuilder scheme(String scheme) {
        this.scheme = UriBuilder.emptyToNull(scheme);
        return this;
    }

    public UriBuilder rawFragment(String fragment) {
        this.requireUrlEncoded(fragment, ADDITIONAL_ALLOWED_FRAGMENT_CHARACTERS);
        this.fragment = UriBuilder.emptyToNull(fragment);
        return this;
    }

    public UriBuilder fragment(String fragment) {
        this.fragment = UriBuilder.encodeFragment(UriBuilder.emptyToNull(fragment));
        return this;
    }

    public UriBuilder rawUserInfo(String userInfo) {
        this.requireUrlEncoded(userInfo, ":");
        this.userInfo = UriBuilder.emptyToNull(userInfo);
        return this;
    }

    public UriBuilder userInfo(String username, String password) {
        if (username == null) {
            this.userInfo = null;
            return this;
        }
        Objects.requireNonNull(password);
        this.userInfo = UriBuilder.urlEncode(username).concat(":").concat(UriBuilder.urlEncode(password));
        return this;
    }

    public UriBuilder host(String host) {
        this.host = UriBuilder.emptyToNull(host);
        return this;
    }

    public UriBuilder port(int port) {
        this.port = port;
        return this;
    }

    public UriBuilder rawPath(String path) {
        this.requireUrlEncoded(path, "/");
        this.pathComponents = null;
        this.path = UriBuilder.emptyToNull(path);
        return this;
    }

    public UriBuilder appendRawPath(String path) {
        this.requireUrlEncoded(path, "/");
        this.initPath();
        if (this.path == null) {
            return this.rawPath(path);
        }
        if (path.startsWith("/")) {
            if (this.path.endsWith("/")) {
                if (path.length() > 1) {
                    this.path = this.path.concat(path.substring(1));
                }
            } else {
                this.path = this.path.concat(path);
            }
        } else {
            this.path = this.path.endsWith("/") ? this.path.concat(path) : this.path.concat("/").concat(path);
        }
        return this;
    }

    public UriBuilder relativePath(boolean relativePath) {
        return this.absolutePath(!relativePath);
    }

    public UriBuilder absolutePath(boolean absolutePath) {
        this.initPathComponents();
        this.absolutePath = absolutePath;
        return this;
    }

    public UriBuilder pathComponent(String path) {
        UriBuilder.requireText(path);
        this.initPathComponents();
        this.pathComponents.add(UriBuilder.urlEncode(path));
        return this;
    }

    public UriBuilder pathComponents(String ... paths) {
        Objects.requireNonNull(paths);
        this.initPathComponents();
        for (String path : paths) {
            UriBuilder.requireText(path);
            this.pathComponents.add(UriBuilder.urlEncode(path));
        }
        return this;
    }

    private void initPathComponents() {
        if (this.pathComponents == null) {
            this.pathComponents = new ArrayList<String>();
            if (this.path != null && !this.path.isEmpty()) {
                this.absolutePath = this.path.startsWith("/");
                StringTokenizer st = new StringTokenizer(this.path, "/");
                while (st.hasMoreTokens()) {
                    this.pathComponents.add(st.nextToken());
                }
            }
            this.path = null;
        } else if (this.path != null) {
            throw new IllegalStateException();
        }
    }

    private void initPath() {
        if (this.path == null) {
            if (this.pathComponents != null && !this.pathComponents.isEmpty()) {
                StringBuilder sb = new StringBuilder();
                for (String pathComponent : this.pathComponents) {
                    if (this.absolutePath || sb.length() != 0) {
                        sb.append('/');
                    }
                    sb.append(pathComponent);
                }
                this.path = sb.toString();
            }
            this.pathComponents = null;
        } else if (this.pathComponents != null) {
            throw new IllegalStateException();
        }
    }

    public UriBuilder rawQuery(String query) {
        this.requireUrlEncoded(query, "&=");
        this.query = UriBuilder.emptyToNull(query);
        return this;
    }

    public UriBuilder addParameter(String name, String value) {
        if (this.queryParameters == null) {
            this.initQueryParameters();
        }
        this.queryParameters.add(new QueryParameter(name, value));
        return this;
    }

    public UriBuilder addParameter(String name, int value) {
        return this.addParameter(name, String.valueOf(value));
    }

    public UriBuilder addParameter(String name, long value) {
        return this.addParameter(name, String.valueOf(value));
    }

    public UriBuilder addParameter(String name, boolean value) {
        return this.addParameter(name, String.valueOf(value));
    }

    public UriBuilder addParameters(Map<String, String> parameters) {
        if (this.queryParameters == null) {
            this.initQueryParameters();
        }
        for (Map.Entry<String, String> e : parameters.entrySet()) {
            this.queryParameters.add(new QueryParameter(e.getKey(), e.getValue()));
        }
        return this;
    }

    public UriBuilder removeParameters(String name) {
        Objects.requireNonNull(name);
        if (this.queryParameters == null) {
            this.initQueryParameters();
        }
        Iterator<QueryParameter> iterator = this.queryParameters.iterator();
        while (iterator.hasNext()) {
            QueryParameter p = iterator.next();
            if (!name.equals(p.name)) continue;
            iterator.remove();
        }
        return this;
    }

    public UriBuilder setParameter(String name, String value) {
        return this.removeParameters(name).addParameter(name, value);
    }

    public UriBuilder setParameter(String name, int value) {
        return this.removeParameters(name).addParameter(name, value);
    }

    public UriBuilder setParameter(String name, long value) {
        return this.removeParameters(name).addParameter(name, value);
    }

    public UriBuilder setParameter(String name, boolean value) {
        return this.removeParameters(name).addParameter(name, value);
    }

    public String getScheme() {
        return this.scheme;
    }

    public String getRawUserInfo() {
        return this.userInfo;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public String getRawPath() {
        this.initPath();
        return this.path;
    }

    public List<String> getPathComponents() {
        this.initPathComponents();
        if (this.pathComponents == null) {
            throw new IllegalStateException();
        }
        if (this.pathComponents.isEmpty()) {
            return Collections.emptyList();
        }
        if (this.pathComponents.size() == 1) {
            return Collections.singletonList(UriBuilder.urlDecode(this.pathComponents.get(0)));
        }
        ArrayList<String> result = new ArrayList<String>(this.pathComponents.size());
        for (String pathComponent : this.pathComponents) {
            result.add(UriBuilder.urlDecode(pathComponent));
        }
        return Collections.unmodifiableList(result);
    }

    public boolean isAbsolutePath() {
        return this.absolutePath;
    }

    public boolean isRelativePath() {
        return !this.absolutePath;
    }

    public String getFragment() {
        if (this.fragment == null || this.fragment.isEmpty()) {
            return this.fragment;
        }
        return UriBuilder.urlDecode(this.fragment);
    }

    public String getRawFragment() {
        return this.fragment;
    }

    public String getRawQuery() {
        this.initQuery();
        return this.query;
    }

    public String getParameterValue(String name) {
        Objects.requireNonNull(name);
        if (this.queryParameters == null) {
            this.initQueryParameters();
        }
        for (QueryParameter p : this.queryParameters) {
            if (!name.equals(p.name)) continue;
            return p.value;
        }
        return null;
    }

    public List<String> getParameterValues(String name) {
        Objects.requireNonNull(name);
        if (this.queryParameters == null) {
            this.initQueryParameters();
        }
        ArrayList<String> values = null;
        for (QueryParameter p : this.queryParameters) {
            if (!name.equals(p.name)) continue;
            if (values == null) {
                values = new ArrayList<String>(1);
            }
            values.add(p.value);
        }
        if (values == null) {
            return Collections.emptyList();
        }
        return values;
    }

    public Set<String> getParameterNames() {
        if (this.queryParameters == null) {
            this.initQueryParameters();
        }
        if (this.queryParameters.isEmpty()) {
            return Collections.emptySet();
        }
        HashSet<String> parameterNames = Sets.newHashSet(this.queryParameters.size());
        for (QueryParameter queryParameter : this.queryParameters) {
            parameterNames.add(queryParameter.name);
        }
        return parameterNames;
    }

    public URI toUri() {
        try {
            return new URI(this.toString());
        }
        catch (URISyntaxException e) {
            throw new UncheckedURISyntaxException(e);
        }
    }

    public URI build() {
        return this.toUri();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        this.appendScheme(sb);
        this.appendHost(sb);
        this.appendPath(sb);
        this.appendQuery(sb);
        this.appendFragment(sb);
        return sb.toString();
    }

    public String getHostWithoutPath() {
        StringBuilder sb = new StringBuilder();
        this.appendScheme(sb);
        this.appendHost(sb);
        return sb.toString();
    }

    private void appendScheme(StringBuilder sb) {
        if (this.scheme != null) {
            sb.append(this.scheme);
            sb.append(':');
        }
    }

    private void appendHost(StringBuilder sb) {
        if (this.host != null) {
            boolean needBrackets;
            sb.append("//");
            if (this.userInfo != null) {
                sb.append(this.userInfo);
                sb.append('@');
            }
            boolean bl = needBrackets = this.host.indexOf(58) >= 0 && !this.host.startsWith("[") && !this.host.endsWith("]");
            if (needBrackets) {
                sb.append('[');
            }
            sb.append(this.host);
            if (needBrackets) {
                sb.append(']');
            }
            if (!(this.port == -1 || this.port == 80 && "http".equals(this.scheme) || this.port == 443 && "https".equals(this.scheme))) {
                sb.append(':');
                sb.append(this.port);
            }
        }
    }

    private void appendPath(StringBuilder sb) {
        this.initPath();
        if (this.path != null) {
            if (!this.path.startsWith("/") && this.host != null) {
                sb.append('/');
            }
            sb.append(this.path);
        }
    }

    private void appendQuery(StringBuilder sb) {
        this.initQuery();
        if (this.query != null) {
            sb.append('?');
            sb.append(this.query);
        }
    }

    private void appendFragment(StringBuilder sb) {
        if (this.fragment != null) {
            sb.append('#');
            sb.append(this.fragment);
        }
    }

    private void initQueryParameters() {
        if (this.queryParameters == null) {
            this.queryParameters = new ArrayList<QueryParameter>();
            if (this.query != null && !this.query.isEmpty()) {
                StringTokenizer st = new StringTokenizer(this.query, "&");
                while (st.hasMoreTokens()) {
                    String pair = st.nextToken();
                    this.queryParameters.add(QueryParameter.ofEncodedPair(pair));
                }
            }
            this.query = null;
        } else if (this.query != null) {
            throw new IllegalStateException();
        }
    }

    private void initQuery() {
        if (this.query == null) {
            if (this.queryParameters != null) {
                StringBuilder sb = new StringBuilder();
                for (QueryParameter parameter : this.queryParameters) {
                    if (sb.length() > 0) {
                        sb.append('&');
                    }
                    parameter.appendEncodedPair(sb);
                }
                this.query = sb.toString();
            }
            this.queryParameters = null;
        } else if (this.queryParameters != null) {
            throw new IllegalStateException();
        }
    }

    private void requireUrlEncoded(String s, String additionalAllowedCharacters) {
        if (s == null || s.isEmpty()) {
            return;
        }
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (UriBuilder.isUnreservedUrlCharacter(c) || c == '+' || c == '%' || additionalAllowedCharacters.indexOf(c) != -1) continue;
            throw new IllegalArgumentException("Unsufficient URL encoding: " + s);
        }
    }

    private static boolean isUnreservedUrlCharacter(char c) {
        return c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9' || c == '-' || c == '_' || c == '.' || c == '!' || c == '~' || c == '*' || c == '\'' || c == '(' || c == ')';
    }

    private static String encodeFragment(String fragment) {
        StringBuilder sb = new StringBuilder();
        for (int idx = 0; idx < fragment.length(); ++idx) {
            char c = fragment.charAt(idx);
            if (UriBuilder.needsEncoding(c, ADDITIONAL_ALLOWED_FRAGMENT_CHARACTERS)) {
                sb.append(UriBuilder.urlEncode(String.valueOf(c)));
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    private static boolean needsEncoding(char c, String additionalAllowedCharacters) {
        return !UriBuilder.isUnreservedUrlCharacter(c) && additionalAllowedCharacters.indexOf(c) == -1;
    }

    private static String urlEncode(String s) {
        if (s == null || s.isEmpty()) {
            return s;
        }
        try {
            return URLEncoder.encode(s, UTF_8);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    private static String urlDecode(String s) {
        if (s == null || s.isEmpty()) {
            return s;
        }
        try {
            return URLDecoder.decode(s, UTF_8);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    private static String requireText(String s) {
        if (s == null || s.isEmpty() || s.trim().isEmpty()) {
            throw new IllegalArgumentException();
        }
        return s;
    }

    private static class QueryParameter {
        private final String name;
        private final String value;

        public QueryParameter(String name, String value) {
            UriBuilder.requireText(name);
            this.name = name;
            this.value = value;
        }

        public static QueryParameter ofEncodedPair(String s) {
            if (s.isEmpty()) {
                throw new IllegalArgumentException();
            }
            int idx = s.indexOf(61);
            if (idx == 0) {
                throw new IllegalArgumentException();
            }
            if (idx == -1) {
                return QueryParameter.ofEncoded(s, null);
            }
            if (idx == s.length() - 1) {
                return QueryParameter.ofEncoded(s.substring(0, idx), "");
            }
            String encodedName = s.substring(0, idx);
            String encodedValue = s.substring(idx + 1);
            return QueryParameter.ofEncoded(encodedName, encodedValue);
        }

        public static QueryParameter ofEncoded(String name, String value) {
            return new QueryParameter(UriBuilder.urlDecode(name), UriBuilder.urlDecode(value));
        }

        public void appendEncodedPair(StringBuilder sb) {
            sb.append(UriBuilder.urlEncode(this.name));
            if (this.value != null) {
                sb.append('=');
                sb.append(UriBuilder.urlEncode(this.value));
            }
        }
    }
}

