/*
 * Decompiled with CFR 0.152.
 */
package de.mklinger.qetcher.client.common;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class Sets {
    private static final int MIN_INITIAL_CAPACITY = 4;

    private Sets() {
    }

    public static <T> HashSet<T> newHashSet(int expectedSize) {
        return new HashSet(Math.max((int)((float)expectedSize / 0.75f) + 1, 4));
    }

    @SafeVarargs
    public static <T> HashSet<T> newHashSet(T ... elements) {
        HashSet<T> set = Sets.newHashSet(elements.length);
        Collections.addAll(set, elements);
        return set;
    }

    public static <T> Set<T> newImmutableSet(Collection<T> original) {
        if (original == null || original.isEmpty()) {
            return Collections.emptySet();
        }
        if (original.size() == 1) {
            return Collections.singleton(original.iterator().next());
        }
        return Collections.unmodifiableSet(new HashSet<T>(original));
    }
}

