/*
 * Decompiled with CFR 0.152.
 */
package de.mklinger.qetcher.client;

import de.mklinger.qetcher.client.common.QetcherException;
import de.mklinger.qetcher.client.model.v1.Error;

public class QetcherRemoteException
extends QetcherException {
    private static final long serialVersionUID = 1L;
    private final Error error;
    private final int statusCode;

    public QetcherRemoteException(Error error, int statusCode) {
        super("Remote error: {}", QetcherRemoteException.toMessage(error));
        this.error = error;
        this.statusCode = statusCode;
    }

    private static String toMessage(Error errorResponse) {
        String status = errorResponse.getStatus();
        String message = errorResponse.getMessage();
        String errorId = errorResponse.getErrorId();
        if (status == null && message == null && errorId == null) {
            return "No error information";
        }
        StringBuilder sb = new StringBuilder(64);
        QetcherRemoteException.appendIfAvailable(sb, "Status", status);
        QetcherRemoteException.appendIfAvailable(sb, "Error Id", errorId);
        QetcherRemoteException.appendIfAvailable(sb, "message", message);
        return sb.toString();
    }

    private static void appendIfAvailable(StringBuilder sb, String prefix, String value) {
        if (value != null && !value.isEmpty()) {
            if (sb.length() > 0) {
                sb.append(" - ");
            }
            sb.append(prefix);
            sb.append(": ");
            sb.append(value);
        }
    }

    public Error getError() {
        return this.error;
    }

    public int getStatusCode() {
        return this.statusCode;
    }
}

