/*
 * Decompiled with CFR 0.152.
 */
package de.mklinger.qetcher.client;

import de.mklinger.qetcher.client.InputConversionFile;
import de.mklinger.qetcher.client.InputJob;
import de.mklinger.qetcher.client.model.v1.AvailableConversion;
import de.mklinger.qetcher.client.model.v1.AvailableNode;
import de.mklinger.qetcher.client.model.v1.ConversionFile;
import de.mklinger.qetcher.client.model.v1.Job;
import java.io.File;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.security.KeyStore;
import java.util.List;
import java.util.concurrent.CompletableFuture;

public interface QetcherClient
extends AutoCloseable {
    public CompletableFuture<ConversionFile> uploadFile(InputConversionFile var1);

    public CompletableFuture<ConversionFile> getFile(String var1);

    public CompletableFuture<List<ConversionFile>> getFiles();

    public CompletableFuture<Void> deleteFile(String var1);

    public CompletableFuture<Path> downloadAsFile(String var1, Path var2, OpenOption ... var3);

    public CompletableFuture<Job> createJob(InputJob var1);

    public CompletableFuture<Job> getJob(String var1);

    public CompletableFuture<List<Job>> getJobs();

    public CompletableFuture<Void> deleteJob(String var1);

    public CompletableFuture<List<AvailableConversion>> getAvailableConversions();

    public CompletableFuture<List<AvailableNode>> getAvailableNodes();

    public CompletableFuture<ConversionFile> getFile(ConversionFile var1);

    public CompletableFuture<Void> deleteFile(ConversionFile var1);

    public CompletableFuture<Path> downloadAsFile(String var1, Path var2);

    public CompletableFuture<File> downloadAsFile(String var1, File var2);

    public CompletableFuture<Path> downloadAsTempFile(String var1);

    public CompletableFuture<Path> downloadAsTempFile(String var1, Path var2);

    public CompletableFuture<Job> getJob(Job var1);

    public CompletableFuture<Void> deleteJob(Job var1);

    public CompletableFuture<Job> getJobDone(Job var1);

    public CompletableFuture<Job> getJobDone(String var1);

    @Override
    public void close();

    public static interface Builder {
        public Builder serviceAddresses(String ... var1);

        public Builder withServiceAddress(String var1);

        public Builder withServiceAddress(String var1, int var2);

        public Builder disableServiceLookup();

        public Builder trustStore(KeyStore var1);

        public Builder keyStore(KeyStore var1, String var2);

        public QetcherClient build();
    }
}

