package de.mklinger.qetcher.client.model.v1.builder;

import de.mklinger.qetcher.client.model.v1.JobPatch;
import de.mklinger.qetcher.client.model.v1.JobState;
import de.mklinger.qetcher.client.model.v1.impl.JobPatchImpl;

/**
 * @author Marc Klinger - mklinger[at]mklinger[dot]de
 */
public class JobPatchBuilder {
	private JobState state;

	public static JobPatchBuilder of(final JobPatch jobPatch) {
		return new JobPatchBuilder()
				.state(jobPatch.getState());
	}

	public JobPatchBuilder state(final JobState state) {
		this.state = state;
		return this;
	}

	public JobPatchBuilder cancel() {
		return state(JobState.CANCELED);
	}

	public JobPatch build() {
		return new JobPatchImpl(this);
	}

	public JobState getState() {
		return state;
	}
}
