/*
 * Decompiled with CFR 0.152.
 */
package de.mklinger.qetcher.client.model.v1.impl;

import de.mklinger.qetcher.client.common.MediaType;
import de.mklinger.qetcher.client.common.Sets;
import de.mklinger.qetcher.client.model.v1.Conversion;
import de.mklinger.qetcher.client.model.v1.ModelValidationException;
import de.mklinger.qetcher.client.model.v1.builder.ConversionBuilder;
import java.util.Objects;
import java.util.Set;

public class ConversionImpl
implements Conversion {
    private final MediaType from;
    private final MediaType to;
    private final int priority;
    private final Set<String> supportedParameters;

    public ConversionImpl(ConversionBuilder conversionBuilder) {
        this.from = conversionBuilder.getFrom();
        this.to = conversionBuilder.getTo();
        this.priority = conversionBuilder.getPriority();
        this.supportedParameters = Sets.newImmutableSet(conversionBuilder.getSupportedParameters());
        try {
            this.validate();
        }
        catch (Exception e) {
            throw new ModelValidationException(Conversion.class, (Throwable)e);
        }
    }

    private void validate() {
        Objects.requireNonNull(this.from);
        Objects.requireNonNull(this.to);
        Objects.requireNonNull(this.supportedParameters);
    }

    @Override
    public MediaType getFrom() {
        return this.from;
    }

    @Override
    public MediaType getTo() {
        return this.to;
    }

    @Override
    public int getPriority() {
        return this.priority;
    }

    @Override
    public Set<String> getSupportedParameters() {
        return this.supportedParameters;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("ConversionImpl [from=");
        sb.append(this.from);
        sb.append(", to=");
        sb.append(this.to);
        sb.append(", priority=");
        sb.append(this.priority);
        sb.append(", supportedParameters=");
        sb.append(this.supportedParameters);
        sb.append("]");
        return sb.toString();
    }
}

