/*
 * Decompiled with CFR 0.152.
 */
package de.mklinger.qetcher.client.deps.jackson.datatype.jsr310.deser;

import de.mklinger.qetcher.client.deps.jackson.annotation.JsonFormat;
import de.mklinger.qetcher.client.deps.jackson.core.JsonParser;
import de.mklinger.qetcher.client.deps.jackson.databind.BeanProperty;
import de.mklinger.qetcher.client.deps.jackson.databind.DeserializationContext;
import de.mklinger.qetcher.client.deps.jackson.databind.JsonDeserializer;
import de.mklinger.qetcher.client.deps.jackson.databind.JsonMappingException;
import de.mklinger.qetcher.client.deps.jackson.databind.deser.ContextualDeserializer;
import de.mklinger.qetcher.client.deps.jackson.datatype.jsr310.deser.JSR310DeserializerBase;
import java.io.IOException;
import java.time.format.DateTimeFormatter;
import java.util.Locale;

public abstract class JSR310DateTimeDeserializerBase<T>
extends JSR310DeserializerBase<T>
implements ContextualDeserializer {
    protected final DateTimeFormatter _formatter;

    protected JSR310DateTimeDeserializerBase(Class<T> supportedType, DateTimeFormatter f) {
        super(supportedType);
        this._formatter = f;
    }

    protected abstract JsonDeserializer<T> withDateFormat(DateTimeFormatter var1);

    @Override
    public JsonDeserializer<?> createContextual(DeserializationContext ctxt, BeanProperty property) throws JsonMappingException {
        JsonFormat.Value format = this.findFormatOverrides(ctxt, property, this.handledType());
        if (format != null && format.hasPattern()) {
            String pattern = format.getPattern();
            Locale locale = format.hasLocale() ? format.getLocale() : ctxt.getLocale();
            DateTimeFormatter df = locale == null ? DateTimeFormatter.ofPattern(pattern) : DateTimeFormatter.ofPattern(pattern, locale);
            if (format.hasTimeZone()) {
                df = df.withZone(format.getTimeZone().toZoneId());
            }
            return this.withDateFormat(df);
        }
        return this;
    }

    protected void _throwNoNumericTimestampNeedTimeZone(JsonParser p, DeserializationContext ctxt) throws IOException {
        ctxt.reportInputMismatch(this.handledType(), "raw timestamp (%d) not allowed for `%s`: need additional information such as an offset or time-zone (see class Javadocs)", p.getNumberValue(), this.handledType().getName());
    }
}

