/*
 * Decompiled with CFR 0.152.
 */
package de.mklinger.qetcher.client.common;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class MediaType {
    private static final String MEDIA_TYPE_WILDCARD = "*";
    private final String type;
    private final String subtype;
    private Map<String, String> parameters;
    private static final char[] quotedChars = "()<>@,;:\\\"/[]?= \t\r\n".toCharArray();

    public MediaType(String type, String subtype, Map<String, String> parameters) {
        this.type = type == null ? MEDIA_TYPE_WILDCARD : type;
        this.subtype = subtype == null ? MEDIA_TYPE_WILDCARD : subtype;
        this.parameters = parameters == null ? Collections.emptyMap() : Collections.unmodifiableMap(parameters);
    }

    public MediaType(String type, String subtype) {
        this(type, subtype, null);
    }

    public static MediaType valueOf(String type) {
        return MediaType.parse(type);
    }

    public String getType() {
        return this.type;
    }

    public boolean isWildcardType() {
        return this.getType().equals(MEDIA_TYPE_WILDCARD);
    }

    public String getSubtype() {
        return this.subtype;
    }

    public boolean isWildcardSubtype() {
        return this.getSubtype().equals(MEDIA_TYPE_WILDCARD);
    }

    public Map<String, String> getParameters() {
        return this.parameters;
    }

    public MediaType withoutParameters() {
        if (this.parameters == null || this.parameters.isEmpty()) {
            return this;
        }
        return new MediaType(this.type, this.subtype);
    }

    public MediaType withoutParameters(String ... names) {
        assert (names != null);
        assert (names.length > 0);
        if (this.parameters == null || this.parameters.isEmpty()) {
            return this;
        }
        return new MediaType(this.type, this.subtype);
    }

    public MediaType withParameter(String name, String value) {
        return this.withParameters(Collections.singletonMap(name, value));
    }

    public MediaType withParameters(Map<String, String> additionalParameters) {
        if (additionalParameters == null || additionalParameters.isEmpty()) {
            return this;
        }
        if (this.parameters == null || this.parameters.isEmpty()) {
            return new MediaType(this.type, this.subtype, additionalParameters);
        }
        HashMap<String, String> allParameters = new HashMap<String, String>(this.parameters);
        allParameters.putAll(additionalParameters);
        return new MediaType(this.type, this.subtype, allParameters);
    }

    public boolean isCompatible(MediaType other) {
        return other != null && (this.type.equals(MEDIA_TYPE_WILDCARD) || other.type.equals(MEDIA_TYPE_WILDCARD) || this.type.equalsIgnoreCase(other.type) && (this.subtype.equals(MEDIA_TYPE_WILDCARD) || other.subtype.equals(MEDIA_TYPE_WILDCARD)) || this.type.equalsIgnoreCase(other.type) && this.subtype.equalsIgnoreCase(other.subtype));
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof MediaType)) {
            return false;
        }
        MediaType other = (MediaType)obj;
        return this.type.equalsIgnoreCase(other.type) && this.subtype.equalsIgnoreCase(other.subtype) && this.parameters.equals(other.parameters);
    }

    public int hashCode() {
        return (this.type.toLowerCase() + this.subtype.toLowerCase()).hashCode() + this.parameters.hashCode();
    }

    public String toString() {
        return MediaType.toString(this, true);
    }

    public String getFullType() {
        return MediaType.toString(this, false);
    }

    public static boolean quoted(String str) {
        for (char c : str.toCharArray()) {
            for (char q : quotedChars) {
                if (c != q) continue;
                return true;
            }
        }
        return false;
    }

    private static String toString(MediaType type, boolean withParameters) {
        if (type == null) {
            throw new IllegalArgumentException("param was null");
        }
        StringBuilder buf = new StringBuilder();
        buf.append(type.getType().toLowerCase());
        buf.append("/");
        buf.append(type.getSubtype().toLowerCase());
        if (!withParameters || type.getParameters() == null || type.getParameters().isEmpty()) {
            return buf.toString();
        }
        for (String name : type.getParameters().keySet()) {
            buf.append(';');
            buf.append(name);
            buf.append('=');
            String val = type.getParameters().get(name);
            if (MediaType.quoted(val)) {
                buf.append('\"');
                buf.append(val);
                buf.append('\"');
                continue;
            }
            buf.append(val);
        }
        return buf.toString();
    }

    private static MediaType parse(String type) {
        String params = null;
        int idx = type.indexOf(";");
        if (idx > -1) {
            params = type.substring(idx + 1).trim();
            type = type.substring(0, idx);
        }
        String major = null;
        String subtype = null;
        String[] paths = type.split("/");
        if (paths.length < 2 && type.equals(MEDIA_TYPE_WILDCARD)) {
            major = MEDIA_TYPE_WILDCARD;
            subtype = MEDIA_TYPE_WILDCARD;
        } else {
            if (paths.length != 2 || "".equals(paths[0]) || "".equals(paths[1]) || paths[0].contains(" ") || paths[1].contains(" ")) {
                throw new IllegalArgumentException("Failure parsing MediaType string: " + type);
            }
            if (paths.length == 2) {
                major = paths[0];
                subtype = paths[1];
            }
        }
        if (params != null && !params.equals("")) {
            HashMap<String, String> typeParams = new HashMap<String, String>();
            int start = 0;
            while (start < params.length()) {
                start = MediaType.setParam(typeParams, params, start);
            }
            return new MediaType(major, subtype, typeParams);
        }
        return new MediaType(major, subtype);
    }

    private static int getEndName(String params, int start) {
        int equals = params.indexOf(61, start);
        int semicolon = params.indexOf(59, start);
        if (equals == -1 && semicolon == -1) {
            return params.length();
        }
        if (equals == -1) {
            return semicolon;
        }
        if (semicolon == -1) {
            return equals;
        }
        int end = equals < semicolon ? equals : semicolon;
        return end;
    }

    private static int setParam(HashMap<String, String> typeParams, String params, int start) {
        int i;
        boolean quote = false;
        boolean backslash = false;
        int end = MediaType.getEndName(params, start);
        String name = params.substring(start, end).trim();
        if (end < params.length() && params.charAt(end) == '=') {
            ++end;
        }
        StringBuilder buffer = new StringBuilder(params.length() - end);
        block5: for (i = end; i < params.length(); ++i) {
            char c = params.charAt(i);
            switch (c) {
                case '\"': {
                    if (backslash) {
                        backslash = false;
                        buffer.append(c);
                        continue block5;
                    }
                    quote = !quote;
                    continue block5;
                }
                case '\\': {
                    if (!backslash) continue block5;
                    backslash = false;
                    buffer.append(c);
                    continue block5;
                }
                case ';': {
                    if (!quote) {
                        String value = buffer.toString().trim();
                        typeParams.put(name, value);
                        return i + 1;
                    }
                    buffer.append(c);
                    continue block5;
                }
                default: {
                    buffer.append(c);
                }
            }
        }
        String value = buffer.toString().trim();
        typeParams.put(name, value);
        return i;
    }

    public String getParameter(String name) {
        String value = this.getParameters().get(name);
        if (value == null || value.isEmpty()) {
            return null;
        }
        return value;
    }

    public Integer getParameterInteger(String name) {
        String value = this.getParameters().get(name);
        if (value == null || value.isEmpty()) {
            return null;
        }
        return Integer.parseInt(value);
    }

    public boolean getParameterBoolean(String name, boolean defaultValue) {
        String value = this.getParameters().get(name);
        if (value == null || value.isEmpty()) {
            return defaultValue;
        }
        return Boolean.parseBoolean(value);
    }
}

