package de.mklinger.qetcher.client;

import java.time.Duration;
import java.util.List;

import de.mklinger.qetcher.client.model.v1.ConversionFile;
import de.mklinger.qetcher.client.model.v1.MediaType;

/**
 * @author Marc Klinger - mklinger[at]mklinger[dot]de
 */
public interface InputJob {
	List<String> getConversionFileIds();
	InputConversionFile getInputConversionFile();
	MediaType getFromMediaType();
	MediaType getToMediaType();
	Duration getDeleteTimeout();
	Duration getCancelTimeout();
	String getReferrer();

	public interface Builder {
		/**
		 * Use the given conversion files as input file for the job.
		 */
		Builder fromFile(String conversionFileId);

		/**
		 * Use the given conversion files as input file for the job.
		 */
		Builder fromFile(ConversionFile conversionFile);

		/**
		 * Use the given conversion files as input files for the job.
		 * <p>
		 * <strong>Note:</strong> Using multiple input files is only useful and
		 * supported for very few conversions. Usually, {@link #fromFile(String)} should
		 * be used instead.
		 * </p>
		 */
		Builder fromFiles(String... conversionFileId);

		/**
		 * Use the given conversion files as input files for the job.
		 * <p>
		 * <strong>Note:</strong> Using multiple input files is only useful and
		 * supported for very few conversions. Usually,
		 * {@link #fromFile(ConversionFile)} should be used instead.
		 * </p>
		 */
		Builder fromFiles(ConversionFile... conversionFile);

		Builder fromFile(InputConversionFile inputConversionFile);
		Builder fromMediaType(MediaType mediaType);
		Builder toMediaType(MediaType mediaType);
		Builder deleteTimeout(Duration deleteTimeout);
		Builder cancelTimeout(Duration cancelTimeout);
		Builder referrer(String referrer);
		InputJob build();
	}
}
