package de.mklinger.qetcher.client.impl.lookup;

import de.mklinger.micro.closeables.Closeables;
import de.mklinger.qetcher.client.impl.QetcherClientBuilderImpl;
import de.mklinger.qetcher.client.impl.retry.RetryingQetcherClientImpl;

/**
 * @author Marc Klinger - mklinger[at]mklinger[dot]de
 */
public class NodeLookupQetcherClientImpl extends RetryingQetcherClientImpl {
	private final ScheduledNodesLookup nodesLookup;

	public NodeLookupQetcherClientImpl(final QetcherClientBuilderImpl builder) {
		super(builder, newDynamicServiceUriSupplier(builder));
		this.nodesLookup = new ScheduledNodesLookup(
				this,
				getServiceUriSupplier().getNodesHolder());
		this.nodesLookup.startDelayed();
	}

	private static ServiceUriSupplier newDynamicServiceUriSupplier(final QetcherClientBuilderImpl builder) {
		return new DynamicServiceUriSupplier(builder.getServiceUris());
	}

	@Override
	public DynamicServiceUriSupplier getServiceUriSupplier() {
		return (DynamicServiceUriSupplier) super.getServiceUriSupplier();
	}

	@Override
	public void close() {
		Closeables.closeUnchecked(nodesLookup, super::close);
	}
}
