package de.mklinger.qetcher.client;

import de.mklinger.qetcher.client.model.v1.Error;

/**
 * @author Marc Klinger - mklinger[at]mklinger[dot]de
 */
public class QetcherRemoteException extends QetcherClientException {
	private static final long serialVersionUID = 1L;

	private final Error error;
	private final int statusCode;

	public QetcherRemoteException(final Error error, final int statusCode) {
		super(newMessage(error, statusCode));
		this.error = error;
		this.statusCode = statusCode;
	}

	private static String newMessage(final Error error, final int statusCode) {
		final String remoteErrorMessage = toMessage(error);
		if (remoteErrorMessage != null) {
			return "Status code: " + statusCode + " Remote error: " + remoteErrorMessage;
		} else {
			return "Status code: " + statusCode;
		}
	}

	private static String toMessage(final Error errorResponse) {
		final String status = errorResponse.getStatus();
		final String message = errorResponse.getMessage();
		final String errorId = errorResponse.getErrorId();

		if (status == null && message == null && errorId == null) {
			return null;
		}

		final StringBuilder sb = new StringBuilder(64);
		appendIfAvailable(sb, "Status", status);
		appendIfAvailable(sb, "Error Id", errorId);
		if (!"Error".equals(message)) {
			appendIfAvailable(sb, "Message", message);
		}
		return sb.toString();
	}

	private static void appendIfAvailable(final StringBuilder sb, final String prefix, final String value) {
		if (value != null && !value.isEmpty()) {
			if (sb.length() > 0) {
				sb.append(" - ");
			}
			sb.append(prefix);
			sb.append(": ");
			sb.append(value);
		}
	}

	public Error getError() {
		return error;
	}

	public int getStatusCode() {
		return statusCode;
	}
}
