/*
 * Decompiled with CFR 0.152.
 */
package de.mklinger.qetcher.client.deps.jetty.client;

import de.mklinger.qetcher.client.deps.jetty.client.HttpClient;
import de.mklinger.qetcher.client.deps.jetty.client.HttpContentResponse;
import de.mklinger.qetcher.client.deps.jetty.client.HttpConversation;
import de.mklinger.qetcher.client.deps.jetty.client.HttpRequest;
import de.mklinger.qetcher.client.deps.jetty.client.HttpResponseException;
import de.mklinger.qetcher.client.deps.jetty.client.ProtocolHandler;
import de.mklinger.qetcher.client.deps.jetty.client.ResponseNotifier;
import de.mklinger.qetcher.client.deps.jetty.client.api.Authentication;
import de.mklinger.qetcher.client.deps.jetty.client.api.Connection;
import de.mklinger.qetcher.client.deps.jetty.client.api.ContentProvider;
import de.mklinger.qetcher.client.deps.jetty.client.api.Request;
import de.mklinger.qetcher.client.deps.jetty.client.api.Response;
import de.mklinger.qetcher.client.deps.jetty.client.api.Result;
import de.mklinger.qetcher.client.deps.jetty.client.util.BufferingResponseListener;
import de.mklinger.qetcher.client.deps.jetty.http.HttpField;
import de.mklinger.qetcher.client.deps.jetty.http.HttpHeader;
import de.mklinger.qetcher.client.deps.jetty.http.QuotedCSV;
import de.mklinger.qetcher.client.deps.jetty.util.StringUtil;
import de.mklinger.qetcher.client.deps.jetty.util.log.Log;
import de.mklinger.qetcher.client.deps.jetty.util.log.Logger;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class AuthenticationProtocolHandler
implements ProtocolHandler {
    public static final int DEFAULT_MAX_CONTENT_LENGTH = 16384;
    public static final Logger LOG = Log.getLogger(AuthenticationProtocolHandler.class);
    private static final Pattern PARAM_PATTERN = Pattern.compile("([^=]+)=([^=]+)?");
    private static final Pattern TYPE_PATTERN = Pattern.compile("([^\\s]+)(\\s+(.*))?");
    private static final Pattern MULTIPLE_CHALLENGE_PATTERN = Pattern.compile("(.*?)\\s*,\\s*([^=\\s,]+(\\s+[^=\\s].*)?)");
    private static final Pattern BASE64_PATTERN = Pattern.compile("[\\+\\-\\.\\/\\dA-Z_a-z~]+=*");
    private final HttpClient client;
    private final int maxContentLength;
    private final ResponseNotifier notifier;

    protected AuthenticationProtocolHandler(HttpClient client, int maxContentLength) {
        this.client = client;
        this.maxContentLength = maxContentLength;
        this.notifier = new ResponseNotifier();
    }

    protected HttpClient getHttpClient() {
        return this.client;
    }

    protected abstract HttpHeader getAuthenticateHeader();

    protected abstract HttpHeader getAuthorizationHeader();

    protected abstract URI getAuthenticationURI(Request var1);

    protected abstract String getAuthenticationAttribute();

    @Override
    public Response.Listener getResponseListener() {
        return new AuthenticationListener();
    }

    protected List<Authentication.HeaderInfo> getHeaderInfo(String value) throws IllegalArgumentException {
        Matcher m;
        String header = value;
        ArrayList<Authentication.HeaderInfo> headerInfos = new ArrayList<Authentication.HeaderInfo>();
        while ((m = MULTIPLE_CHALLENGE_PATTERN.matcher(header)).matches()) {
            headerInfos.add(this.newHeaderInfo(m.group(1)));
            header = m.group(2);
        }
        headerInfos.add(this.newHeaderInfo(header));
        return headerInfos;
    }

    protected Authentication.HeaderInfo newHeaderInfo(String value) throws IllegalArgumentException {
        String type;
        HashMap<String, String> params = new HashMap();
        Matcher m = TYPE_PATTERN.matcher(value);
        if (m.matches()) {
            type = m.group(1);
            if (m.group(2) != null) {
                params = this.parseParameters(m.group(3));
            }
        } else {
            throw new IllegalArgumentException("Invalid Authentication Format");
        }
        return new Authentication.HeaderInfo(this.getAuthorizationHeader(), type, params);
    }

    protected Map<String, String> parseParameters(String wwwAuthenticate) throws IllegalArgumentException {
        HashMap<String, String> result = new HashMap<String, String>();
        Matcher b64 = BASE64_PATTERN.matcher(wwwAuthenticate);
        if (b64.matches()) {
            result.put("base64", wwwAuthenticate);
            return result;
        }
        QuotedCSV parts = new QuotedCSV(false, wwwAuthenticate);
        for (String part : parts) {
            Matcher params = PARAM_PATTERN.matcher(part);
            if (params.matches()) {
                String name = StringUtil.asciiToLowerCase(params.group(1));
                String value = params.group(2) == null ? "" : params.group(2);
                result.put(name, value);
                continue;
            }
            throw new IllegalArgumentException("Invalid Authentication Format");
        }
        return result;
    }

    private class AuthenticationListener
    extends BufferingResponseListener {
        private AuthenticationListener() {
            super(AuthenticationProtocolHandler.this.maxContentLength);
        }

        @Override
        public void onComplete(Result result) {
            HttpRequest request = (HttpRequest)result.getRequest();
            HttpContentResponse response = new HttpContentResponse(result.getResponse(), this.getContent(), this.getMediaType(), this.getEncoding());
            if (result.getResponseFailure() != null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Authentication challenge failed {}", result.getFailure());
                }
                this.forwardFailureComplete(request, result.getRequestFailure(), response, result.getResponseFailure());
                return;
            }
            String authenticationAttribute = AuthenticationProtocolHandler.this.getAuthenticationAttribute();
            HttpConversation conversation = request.getConversation();
            if (conversation.getAttribute(authenticationAttribute) != null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Bad credentials for {}", request);
                }
                this.forwardSuccessComplete(request, response);
                return;
            }
            HttpHeader header = AuthenticationProtocolHandler.this.getAuthenticateHeader();
            List<Authentication.HeaderInfo> headerInfos = this.parseAuthenticateHeader(response, header);
            if (headerInfos.isEmpty()) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Authentication challenge without {} header", new Object[]{header});
                }
                this.forwardFailureComplete(request, result.getRequestFailure(), response, new HttpResponseException("HTTP protocol violation: Authentication challenge without " + (Object)((Object)header) + " header", response));
                return;
            }
            Authentication authentication = null;
            Authentication.HeaderInfo headerInfo = null;
            URI authURI = this.resolveURI(request, AuthenticationProtocolHandler.this.getAuthenticationURI(request));
            if (authURI != null) {
                for (Authentication.HeaderInfo element : headerInfos) {
                    authentication = AuthenticationProtocolHandler.this.client.getAuthenticationStore().findAuthentication(element.getType(), authURI, element.getRealm());
                    if (authentication == null) continue;
                    headerInfo = element;
                    break;
                }
            }
            if (authentication == null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("No authentication available for {}", request);
                }
                this.forwardSuccessComplete(request, response);
                return;
            }
            ContentProvider requestContent = request.getContent();
            if (requestContent != null && !requestContent.isReproducible()) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Request content not reproducible for {}", request);
                }
                this.forwardSuccessComplete(request, response);
                return;
            }
            try {
                Authentication.Result authnResult = authentication.authenticate(request, response, headerInfo, conversation);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Authentication result {}", authnResult);
                }
                if (authnResult == null) {
                    this.forwardSuccessComplete(request, response);
                    return;
                }
                conversation.setAttribute(authenticationAttribute, true);
                URI requestURI = request.getURI();
                String path = null;
                if (requestURI == null) {
                    requestURI = this.resolveURI(request, null);
                    path = request.getPath();
                }
                Request newRequest = AuthenticationProtocolHandler.this.client.copyRequest(request, requestURI);
                if (path != null) {
                    newRequest.path(path);
                }
                authnResult.apply(newRequest);
                this.copyIfAbsent(request, newRequest, HttpHeader.AUTHORIZATION);
                this.copyIfAbsent(request, newRequest, HttpHeader.PROXY_AUTHORIZATION);
                newRequest.onResponseSuccess(r -> AuthenticationProtocolHandler.this.client.getAuthenticationStore().addAuthenticationResult(authnResult));
                Connection connection = (Connection)request.getAttributes().get(Connection.class.getName());
                if (connection != null) {
                    connection.send(newRequest, null);
                } else {
                    newRequest.send(null);
                }
            }
            catch (Throwable x) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Authentication failed", x);
                }
                this.forwardFailureComplete(request, null, response, x);
            }
        }

        private URI resolveURI(HttpRequest request, URI uri) {
            if (uri != null) {
                return uri;
            }
            String target = request.getScheme() + "://" + request.getHost();
            int port = request.getPort();
            if (port > 0) {
                target = target + ":" + port;
            }
            return URI.create(target);
        }

        private void copyIfAbsent(HttpRequest oldRequest, Request newRequest, HttpHeader header) {
            HttpField field = oldRequest.getHeaders().getField(header);
            if (field != null && !newRequest.getHeaders().contains(header)) {
                newRequest.getHeaders().put(field);
            }
        }

        private void forwardSuccessComplete(HttpRequest request, Response response) {
            HttpConversation conversation = request.getConversation();
            conversation.updateResponseListeners(null);
            AuthenticationProtocolHandler.this.notifier.forwardSuccessComplete(conversation.getResponseListeners(), request, response);
        }

        private void forwardFailureComplete(HttpRequest request, Throwable requestFailure, Response response, Throwable responseFailure) {
            HttpConversation conversation = request.getConversation();
            conversation.updateResponseListeners(null);
            List<Response.ResponseListener> responseListeners = conversation.getResponseListeners();
            if (responseFailure == null) {
                AuthenticationProtocolHandler.this.notifier.forwardSuccess(responseListeners, response);
            } else {
                AuthenticationProtocolHandler.this.notifier.forwardFailure(responseListeners, response, responseFailure);
            }
            AuthenticationProtocolHandler.this.notifier.notifyComplete(responseListeners, new Result(request, requestFailure, response, responseFailure));
        }

        private List<Authentication.HeaderInfo> parseAuthenticateHeader(Response response, HttpHeader header) {
            ArrayList<Authentication.HeaderInfo> result = new ArrayList<Authentication.HeaderInfo>();
            List<String> values = response.getHeaders().getValuesList(header);
            for (String value : values) {
                try {
                    result.addAll(AuthenticationProtocolHandler.this.getHeaderInfo(value));
                }
                catch (IllegalArgumentException e) {
                    if (!LOG.isDebugEnabled()) continue;
                    LOG.debug("Failed to parse authentication header", e);
                }
            }
            return result;
        }
    }
}

