/*
 * Decompiled with CFR 0.152.
 */
package de.mklinger.qetch.client.model.v1.jackson;

import de.mklinger.qetch.client.common.MediaType;
import de.mklinger.qetch.client.common.SizeValue;
import de.mklinger.qetch.client.model.v1.Availability;
import de.mklinger.qetch.client.model.v1.AvailableConversion;
import de.mklinger.qetch.client.model.v1.Conversion;
import de.mklinger.qetch.client.model.v1.ConversionFile;
import de.mklinger.qetch.client.model.v1.Error;
import de.mklinger.qetch.client.model.v1.Job;
import de.mklinger.qetch.client.model.v1.NodeAddress;
import de.mklinger.qetch.client.model.v1.impl.AvailabilityImpl;
import de.mklinger.qetch.client.model.v1.impl.AvailableConversionImpl;
import de.mklinger.qetch.client.model.v1.impl.ConversionFileImpl;
import de.mklinger.qetch.client.model.v1.impl.ConversionImpl;
import de.mklinger.qetch.client.model.v1.impl.ErrorImpl;
import de.mklinger.qetch.client.model.v1.impl.JobImpl;
import de.mklinger.qetch.client.model.v1.impl.NodeAddressImpl;
import de.mklinger.qetch.client.model.v1.jackson.QetchJacksonAnnotationIntrospector;
import de.mklinger.qetcher.client.deps.jackson.annotation.JsonInclude;
import de.mklinger.qetcher.client.deps.jackson.core.JsonGenerator;
import de.mklinger.qetcher.client.deps.jackson.core.JsonParser;
import de.mklinger.qetcher.client.deps.jackson.databind.DeserializationContext;
import de.mklinger.qetcher.client.deps.jackson.databind.Module;
import de.mklinger.qetcher.client.deps.jackson.databind.ObjectMapper;
import de.mklinger.qetcher.client.deps.jackson.databind.SerializationFeature;
import de.mklinger.qetcher.client.deps.jackson.databind.SerializerProvider;
import de.mklinger.qetcher.client.deps.jackson.databind.deser.std.StdDeserializer;
import de.mklinger.qetcher.client.deps.jackson.databind.module.SimpleModule;
import de.mklinger.qetcher.client.deps.jackson.databind.ser.std.StdSerializer;
import de.mklinger.qetcher.client.deps.jackson.datatype.jsr310.JavaTimeModule;
import java.io.IOException;

public class ObjectMapperConfigurer {
    public static ObjectMapper configure(ObjectMapper objectMapper) {
        objectMapper.setSerializationInclusion(JsonInclude.Include.NON_ABSENT);
        objectMapper.disable(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS);
        objectMapper.registerModule(new JavaTimeModule());
        objectMapper.registerModule(new QetchJacksonModule());
        return objectMapper;
    }

    private static class JacksonSizeValueDeserializer
    extends StdDeserializer<SizeValue> {
        private static final long serialVersionUID = 1L;

        public JacksonSizeValueDeserializer() {
            super(SizeValue.class);
        }

        @Override
        public SizeValue deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
            return new SizeValue(p.getValueAsLong());
        }
    }

    private static class JacksonSizeValueSerializer
    extends StdSerializer<SizeValue> {
        private static final long serialVersionUID = 1L;

        public JacksonSizeValueSerializer() {
            super(SizeValue.class);
        }

        @Override
        public void serialize(SizeValue value, JsonGenerator gen, SerializerProvider provider) throws IOException {
            gen.writeNumber(value.getSingles());
        }
    }

    private static class JacksonMediaTypeDeserializer
    extends StdDeserializer<MediaType> {
        private static final long serialVersionUID = 1L;

        public JacksonMediaTypeDeserializer() {
            super(MediaType.class);
        }

        @Override
        public MediaType deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
            return MediaType.valueOf(p.getText());
        }
    }

    private static class JacksonMediaTypeSerializer
    extends StdSerializer<MediaType> {
        private static final long serialVersionUID = 1L;

        public JacksonMediaTypeSerializer() {
            super(MediaType.class);
        }

        @Override
        public void serialize(MediaType value, JsonGenerator gen, SerializerProvider provider) throws IOException {
            gen.writeString(value.toString());
        }
    }

    private static class QetchJacksonModule
    extends SimpleModule {
        private static final long serialVersionUID = 1L;

        public QetchJacksonModule() {
            this.addSerializer(new JacksonMediaTypeSerializer());
            this.addDeserializer(MediaType.class, new JacksonMediaTypeDeserializer());
            this.addSerializer(new JacksonSizeValueSerializer());
            this.addDeserializer(SizeValue.class, new JacksonSizeValueDeserializer());
            this.addAbstractTypeMapping(NodeAddress.class, NodeAddressImpl.class);
            this.addAbstractTypeMapping(AvailableConversion.class, AvailableConversionImpl.class);
            this.addAbstractTypeMapping(Availability.class, AvailabilityImpl.class);
            this.addAbstractTypeMapping(Conversion.class, ConversionImpl.class);
            this.addAbstractTypeMapping(Job.class, JobImpl.class);
            this.addAbstractTypeMapping(ConversionFile.class, ConversionFileImpl.class);
            this.addAbstractTypeMapping(Error.class, ErrorImpl.class);
        }

        @Override
        public void setupModule(Module.SetupContext context) {
            context.insertAnnotationIntrospector(new QetchJacksonAnnotationIntrospector());
            super.setupModule(context);
        }
    }
}

