/*
 * Decompiled with CFR 0.152.
 */
package de.mklinger.qetch.client.impl.lookup;

import de.mklinger.qetch.client.QetchClient;
import de.mklinger.qetch.client.common.concurrent.Delay;
import de.mklinger.qetch.client.impl.lookup.NodesHolder;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScheduledNodesLookup
implements AutoCloseable {
    private static final Logger LOG = LoggerFactory.getLogger(ScheduledNodesLookup.class);
    private final QetchClient client;
    private final NodesHolder nodesHolder;
    private final AtomicBoolean closed;

    public ScheduledNodesLookup(QetchClient client, NodesHolder nodesHolder) {
        this.client = client;
        this.nodesHolder = nodesHolder;
        this.closed = new AtomicBoolean();
    }

    public void startDelayed() {
        this.execute(2L, 60L, TimeUnit.SECONDS);
    }

    private void execute(long initialDelay, long delay, TimeUnit unit) {
        Delay.delayedExecutor(initialDelay, unit).execute(() -> this.execute(delay, unit));
    }

    private void execute(long nextDelay, TimeUnit unit) {
        if (this.closed.get()) {
            return;
        }
        LOG.info("Doing nodes lookup...");
        ((CompletableFuture)this.client.getAvailableNodes().thenAccept(this.nodesHolder::setNodes)).whenComplete((unused, error) -> {
            if (this.closed.get()) {
                return;
            }
            if (error != null) {
                LOG.warn("Error on nodes lookup", error);
            } else {
                LOG.info("Nodes lookup successful");
            }
            this.execute(nextDelay, nextDelay, unit);
        });
    }

    @Override
    public void close() {
        this.closed.set(true);
    }
}

