/*
 * Decompiled with CFR 0.152.
 */
package de.mklinger.qetch.client.impl;

import de.mklinger.qetch.client.InputConversionFile;
import de.mklinger.qetch.client.InputJob;
import de.mklinger.qetch.client.impl.AbstractQetchClient;
import de.mklinger.qetch.client.impl.QetchClientBuilderImpl;
import de.mklinger.qetch.client.impl.lookup.ServiceUriSupplier;
import de.mklinger.qetch.client.model.v1.AvailableConversion;
import de.mklinger.qetch.client.model.v1.AvailableConversions;
import de.mklinger.qetch.client.model.v1.AvailableNode;
import de.mklinger.qetch.client.model.v1.AvailableNodes;
import de.mklinger.qetch.client.model.v1.ConversionFile;
import de.mklinger.qetch.client.model.v1.ConversionFiles;
import de.mklinger.qetch.client.model.v1.Job;
import de.mklinger.qetch.client.model.v1.Jobs;
import de.mklinger.qetcher.client.httpclient.BodyHandlers;
import de.mklinger.qetcher.client.httpclient.BodyProviders;
import de.mklinger.qetcher.client.httpclient.HttpClient;
import de.mklinger.qetcher.client.httpclient.HttpRequest;
import de.mklinger.qetcher.client.httpclient.HttpResponse;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QetchClientImpl
extends AbstractQetchClient {
    private static final Logger LOG = LoggerFactory.getLogger(QetchClientImpl.class);
    private final HttpClient httpClient;

    public QetchClientImpl(QetchClientBuilderImpl builder, ServiceUriSupplier serviceUriSupplier) {
        super(serviceUriSupplier);
        this.httpClient = this.newHttpClient(builder);
    }

    private HttpClient newHttpClient(QetchClientBuilderImpl builder) {
        HttpClient.Builder httpClientBuilder = HttpClient.newBuilder();
        if (builder.getTrustStore() != null) {
            httpClientBuilder.trustStore(builder.getTrustStore());
        }
        if (builder.getKeyStore() != null) {
            httpClientBuilder.keyStore(builder.getKeyStore(), builder.getKeyPassword());
        }
        return httpClientBuilder.followRedirects(true).build();
    }

    @Override
    public void close() {
        this.httpClient.close();
    }

    @Override
    public CompletableFuture<ConversionFile> uploadFile(InputConversionFile inputFile) {
        HttpRequest.Builder rb = HttpRequest.newBuilder().uri(this.getFileUploadUri()).method(this.getFileUploadMethod(), inputFile.getBodyProvider());
        rb.header("Content-Type", inputFile.getMediaType().toString());
        if (inputFile.getDeleteTimeout() != null) {
            rb.header("X-Qetch-Delete-Timeout", inputFile.getDeleteTimeout().toString());
        }
        if (inputFile.getFilename() != null && !inputFile.getFilename().isEmpty()) {
            rb.header("X-Qetch-Filename", inputFile.getFilename());
        }
        return this.sendForBytes(rb.build()).thenApply(response -> this.transformResponse((HttpResponse<byte[]>)response, (Class)ConversionFile.class));
    }

    @Override
    public CompletableFuture<ConversionFile> getFile(String fileId) {
        HttpRequest request = HttpRequest.newBuilder().uri(this.getFileUri(fileId)).GET().build();
        return this.sendForBytes(request).thenApply(response -> this.transformResponse((HttpResponse<byte[]>)response, (Class)ConversionFile.class));
    }

    @Override
    public CompletableFuture<List<ConversionFile>> getFiles() {
        HttpRequest request = HttpRequest.newBuilder().uri(this.getFilesUri()).GET().build();
        return ((CompletableFuture)this.sendForBytes(request).thenApply(response -> this.transformResponse((HttpResponse<byte[]>)response, (Class)ConversionFiles.class))).thenApply(ConversionFiles::getConversionFiles);
    }

    @Override
    public CompletableFuture<Void> deleteFile(String fileId) {
        HttpRequest request = HttpRequest.newBuilder().uri(this.getFileUri(fileId)).DELETE(BodyProviders.noBody()).build();
        return this.sendForBytes(request).thenApply(response -> this.transformResponse((HttpResponse<byte[]>)response, (Class)Void.class));
    }

    @Override
    public CompletableFuture<Path> downloadAsFile(String fileId, Path file, OpenOption ... openOptions) {
        HttpRequest request = HttpRequest.newBuilder().uri(this.getFileContentsUri(fileId)).GET().build();
        LOG.debug("{} {}", (Object)request.method(), (Object)request.uri());
        return this.httpClient.sendAsync(request, this.asSuccessStatusFile(file, openOptions)).thenApply(HttpResponse::body);
    }

    private HttpResponse.BodyHandler<Path> asSuccessStatusFile(Path file, OpenOption ... openOptions) {
        return (status, headers) -> {
            this.requireSuccessStatusCode(status, Optional.empty(), Optional.empty());
            return BodyHandlers.asFile(file, openOptions).apply(status, headers);
        };
    }

    @Override
    public CompletableFuture<Job> createJob(InputJob inputJob) {
        if (inputJob.getInputConversionFile() != null) {
            return this.createJobWithUpload(inputJob);
        }
        return this.createJobForExistingFile(inputJob);
    }

    private CompletableFuture<Job> createJobWithUpload(InputJob inputJob) {
        HttpRequest.Builder rb = HttpRequest.newBuilder().uri(this.getCreateJobForNewFileUri()).method(this.getFileUploadMethod(), inputJob.getInputConversionFile().getBodyProvider());
        rb.header("Content-Type", inputJob.getFromMediaType().toString());
        rb.header("X-Qetch-Target-Content-Type", inputJob.getToMediaType().toString());
        if (inputJob.getInputConversionFile().getFilename() != null && !inputJob.getInputConversionFile().getFilename().isEmpty()) {
            rb.header("X-Qetch-Filename", inputJob.getInputConversionFile().getFilename());
        }
        if (inputJob.getDeleteTimeout() != null) {
            rb.header("X-Qetch-Delete-Timeout", inputJob.getDeleteTimeout().toString());
        }
        if (inputJob.getCancelTimeout() != null) {
            rb.header("X-Qetch-Cancel-Timeout", inputJob.getCancelTimeout().toString());
        }
        if (inputJob.getReferrer() != null) {
            rb.header("Referer", inputJob.getReferrer());
        }
        return this.sendForBytes(rb.build()).thenApply(response -> this.transformResponse((HttpResponse<byte[]>)response, (Class)Job.class));
    }

    private CompletableFuture<Job> createJobForExistingFile(InputJob inputJob) {
        HttpRequest.Builder rb = HttpRequest.newBuilder().uri(this.getCreateJobForExistingFileUri()).method(this.getCreateJobForExistingFileMethod(), BodyProviders.noBody());
        rb.header("X-Qetch-FileId", inputJob.getConversionFileId());
        rb.header("X-Qetch-Target-Content-Type", inputJob.getToMediaType().toString());
        if (inputJob.getDeleteTimeout() != null) {
            rb.header("X-Qetch-Delete-Timeout", inputJob.getDeleteTimeout().toString());
        }
        if (inputJob.getCancelTimeout() != null) {
            rb.header("X-Qetch-Cancel-Timeout", inputJob.getCancelTimeout().toString());
        }
        if (inputJob.getReferrer() != null) {
            rb.header("Referer", inputJob.getReferrer());
        }
        return this.sendForBytes(rb.build()).thenApply(response -> this.transformResponse((HttpResponse<byte[]>)response, (Class)Job.class));
    }

    @Override
    public CompletableFuture<Job> getJob(String jobId) {
        HttpRequest request = HttpRequest.newBuilder().uri(this.getJobUri(jobId)).GET().build();
        return this.sendForBytes(request).thenApply(response -> this.transformResponse((HttpResponse<byte[]>)response, (Class)Job.class));
    }

    @Override
    public CompletableFuture<List<Job>> getJobs() {
        HttpRequest request = HttpRequest.newBuilder().uri(this.getJobsUri()).GET().build();
        return ((CompletableFuture)this.sendForBytes(request).thenApply(response -> this.transformResponse((HttpResponse<byte[]>)response, (Class)Jobs.class))).thenApply(Jobs::getJobs);
    }

    @Override
    public CompletableFuture<Void> deleteJob(String jobId) {
        HttpRequest request = HttpRequest.newBuilder().uri(this.getJobUri(jobId)).DELETE(BodyProviders.noBody()).build();
        return this.sendForBytes(request).thenApply(response -> this.transformResponse((HttpResponse<byte[]>)response, (Class)Void.class));
    }

    @Override
    public CompletableFuture<List<AvailableConversion>> getAvailableConversions() {
        HttpRequest request = HttpRequest.newBuilder().uri(this.getConversionsUri()).GET().build();
        return ((CompletableFuture)this.sendForBytes(request).thenApply(response -> this.transformResponse((HttpResponse<byte[]>)response, (Class)AvailableConversions.class))).thenApply(AvailableConversions::getAvailableConversions);
    }

    @Override
    public CompletableFuture<List<AvailableNode>> getAvailableNodes() {
        HttpRequest request = HttpRequest.newBuilder().uri(this.getAvailableNodesUri()).GET().build();
        return ((CompletableFuture)this.sendForBytes(request).thenApply(response -> this.transformResponse((HttpResponse<byte[]>)response, (Class)AvailableNodes.class))).thenApply(AvailableNodes::getAvailableNodes);
    }

    private CompletableFuture<HttpResponse<byte[]>> sendForBytes(HttpRequest request) {
        LOG.debug("{} {}", (Object)request.method(), (Object)request.uri());
        return this.httpClient.sendAsync(request, BodyHandlers.asByteArray());
    }

    private <T> T transformResponse(HttpResponse<byte[]> response, Class<T> type) {
        return this.transformResponse(response.statusCode(), response.headers().firstValue("Content-Type"), response.body(), type);
    }
}

