/*
 * Decompiled with CFR 0.152.
 */
package de.mklinger.qetch.client.impl;

import de.mklinger.qetch.client.QetchClient;
import de.mklinger.qetch.client.impl.InstanceFactory;
import java.net.URI;
import java.security.KeyStore;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public class QetchClientBuilderImpl
implements QetchClient.Builder {
    private List<URI> serviceUris;
    private boolean serviceLookupDisabled;
    private KeyStore trustStore;
    private KeyStore keyStore;
    private String keyPassword;

    @Override
    public QetchClient.Builder serviceAddresses(String ... serviceAddresses) {
        this.serviceUris = new ArrayList<URI>(Arrays.stream(serviceAddresses).map(s -> "https://" + s).map(URI::create).collect(Collectors.toList()));
        return this;
    }

    @Override
    public QetchClient.Builder withServiceAddress(String serviceAddress) {
        if (this.serviceUris == null) {
            this.serviceUris = new ArrayList<URI>();
        }
        this.serviceUris.add(URI.create("https://" + serviceAddress));
        return this;
    }

    @Override
    public QetchClient.Builder withServiceAddress(String host, int port) {
        return this.withServiceAddress(Objects.requireNonNull(host) + ":" + QetchClientBuilderImpl.requireValidPort(port));
    }

    private static int requireValidPort(int port) {
        if (port <= 0) {
            throw new IllegalArgumentException("Invalid port: " + port);
        }
        return port;
    }

    public List<URI> getServiceUris() {
        return this.serviceUris;
    }

    @Override
    public QetchClient.Builder disableServiceLookup() {
        this.serviceLookupDisabled = true;
        return this;
    }

    public boolean isServiceLookupDisabled() {
        return this.serviceLookupDisabled;
    }

    @Override
    public QetchClient.Builder trustStore(KeyStore trustStore) {
        this.trustStore = trustStore;
        return this;
    }

    public KeyStore getTrustStore() {
        return this.trustStore;
    }

    @Override
    public QetchClient.Builder keyStore(KeyStore keyStore, String keyPassword) {
        this.keyStore = keyStore;
        this.keyPassword = keyPassword;
        return this;
    }

    public KeyStore getKeyStore() {
        return this.keyStore;
    }

    public String getKeyPassword() {
        return this.keyPassword;
    }

    @Override
    public QetchClient build() {
        return InstanceFactory.newInstance(this);
    }
}

