/*
 * Decompiled with CFR 0.152.
 */
package de.mklinger.qetch.client.common;

import de.mklinger.qetch.client.common.QetchException;
import java.util.Collection;

public class Closeables {
    private Closeables() {
    }

    public static void closeUnchecked(Collection<? extends AutoCloseable> closeables) {
        Closeables.closeUnchecked(closeables.toArray(new AutoCloseable[closeables.size()]));
    }

    public static void closeUnchecked(AutoCloseable ... closeables) {
        try {
            Closeables.close(closeables);
        }
        catch (Exception e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            if (e instanceof InterruptedException) {
                Thread.currentThread().interrupt();
            }
            throw new QetchException("Error on close", new Object[]{e});
        }
    }

    public static void close(Collection<? extends AutoCloseable> closeables) throws Exception {
        Closeables.close(closeables.toArray(new AutoCloseable[closeables.size()]));
    }

    public static void close(AutoCloseable ... closeables) throws Exception {
        Exception error = null;
        for (AutoCloseable closeable : closeables) {
            try {
                if (closeable == null) continue;
                closeable.close();
            }
            catch (Exception e) {
                if (error == null) {
                    error = e;
                    continue;
                }
                if (e instanceof InterruptedException) {
                    Thread.currentThread().interrupt();
                }
                error.addSuppressed(e);
            }
        }
        if (error != null) {
            throw error;
        }
    }
}

