/*
 * Decompiled with CFR 0.152.
 */
package de.mklinger.qetch.client;

import de.mklinger.qetch.client.common.QetchException;
import de.mklinger.qetch.client.model.v1.Error;

public class QetchRemoteException
extends QetchException {
    private static final long serialVersionUID = 1L;
    private final Error error;
    private final int statusCode;

    public QetchRemoteException(Error error, int statusCode) {
        super("Remote error: {}", QetchRemoteException.toMessage(error));
        this.error = error;
        this.statusCode = statusCode;
    }

    private static String toMessage(Error errorResponse) {
        String status = errorResponse.getStatus();
        String message = errorResponse.getMessage();
        String errorId = errorResponse.getErrorId();
        if (status == null && message == null && errorId == null) {
            return "No error information";
        }
        StringBuilder sb = new StringBuilder(64);
        QetchRemoteException.appendIfAvailable(sb, "Status", status);
        QetchRemoteException.appendIfAvailable(sb, "Error Id", errorId);
        QetchRemoteException.appendIfAvailable(sb, "message", message);
        return sb.toString();
    }

    private static void appendIfAvailable(StringBuilder sb, String prefix, String value) {
        if (value != null && !value.isEmpty()) {
            if (sb.length() > 0) {
                sb.append(" - ");
            }
            sb.append(prefix);
            sb.append(": ");
            sb.append(value);
        }
    }

    public Error getError() {
        return this.error;
    }

    public int getStatusCode() {
        return this.statusCode;
    }
}

