package de.mklinger.qetch.client.model.v1.impl;

import java.util.List;

import de.mklinger.qetch.client.common.Lists;
import de.mklinger.qetch.client.model.v1.ConversionFile;
import de.mklinger.qetch.client.model.v1.ConversionFiles;
import de.mklinger.qetch.client.model.v1.builder.ConversionFilesBuilder;

/**
 * @author Marc Klinger - mklinger[at]mklinger[dot]de
 */
public class ConversionFilesImpl implements ConversionFiles {
	private final List<ConversionFile> conversionFiles;

	public ConversionFilesImpl(final ConversionFilesBuilder builder) {
		this.conversionFiles = Lists.newImmutableList(builder.getConversionFiles());
	}

	@Override
	public List<ConversionFile> getConversionFiles() {
		return conversionFiles;
	}
}
