package de.mklinger.qetch.client.model.v1.builder;

import de.mklinger.qetch.client.model.v1.NodeAddress;
import de.mklinger.qetch.client.model.v1.impl.NodeAddressImpl;

/**
 * Created by Marius Heinzmann on 3/26/18.
 *
 * @author Marius Heinzmann - mheinzmann[at]mklinger[dot]de
 */
public class NodeAddressBuilder {
	private String host;
	private int port;

	public static NodeAddressBuilder of(final NodeAddress nodeAddress) {
		return new NodeAddressBuilder()
				.host(nodeAddress.getHost())
				.port(nodeAddress.getPort());
	}

	/**
	 * Valid addresses:
	 *
	 * 127.0.0.1:8080
	 * [::1]:80
	 * localhost:443
	 */
	public NodeAddressBuilder address(final String address) {
		final int idx = address.lastIndexOf(":");
		if (idx <= 0 || idx == address.length() - 1) {
			throw new IllegalArgumentException("Cannot parse address string: '" + address + "'");
		}

		String host = address.substring(0, idx);
		if (host.startsWith("[")) {
			if (!host.endsWith("]") || host.length() <= 2) {
				throw new IllegalArgumentException("Cannot parse address string host part: '" + address + "'");
			}
			host = host.substring(1, host.length() - 1);
		}

		final int port;
		try {
			port = Integer.parseInt(address.substring(idx + 1));
		} catch (final NumberFormatException e) {
			throw new IllegalArgumentException("Cannot parse address string port part: '" + address + "'");
		}

		return host(host).port(port);
	}

	public NodeAddressBuilder host(final String host) {
		this.host = host;
		return this;
	}

	public NodeAddressBuilder port(final int port) {
		this.port = port;
		return this;
	}

	public NodeAddress build() {
		return new NodeAddressImpl(this);
	}

	public String getHost() {
		return host;
	}

	public int getPort() {
		return port;
	}
}
