package de.mklinger.qetch.client.model.v1.builder;

import java.util.List;

import de.mklinger.qetch.client.model.v1.Job;
import de.mklinger.qetch.client.model.v1.Jobs;
import de.mklinger.qetch.client.model.v1.impl.JobsImpl;

/**
 * @author Marc Klinger - mklinger[at]mklinger[dot]de
 */
public class JobsBuilder {
	private List<Job> jobs;

	public static JobsBuilder of(final Jobs jobs) {
		return new JobsBuilder()
				.jobs(jobs.getJobs());
	}

	public List<Job> getJobs() {
		return jobs;
	}

	public JobsBuilder jobs(final List<Job> jobs) {
		this.jobs = jobs;
		return this;
	}

	public Jobs build() {
		return new JobsImpl(this);
	}
}
