package de.mklinger.qetch.client.model.v1.builder;

import java.util.List;

import de.mklinger.qetch.client.model.v1.ConversionFile;
import de.mklinger.qetch.client.model.v1.ConversionFiles;
import de.mklinger.qetch.client.model.v1.impl.ConversionFilesImpl;

/**
 * @author Marc Klinger - mklinger[at]mklinger[dot]de
 */
public class ConversionFilesBuilder {
	private List<ConversionFile> conversionFiles;

	public static ConversionFilesBuilder of(final ConversionFiles conversionFiles) {
		return new ConversionFilesBuilder()
				.conversionFiles(conversionFiles.getConversionFiles());
	}

	public List<ConversionFile> getConversionFiles() {
		return conversionFiles;
	}

	public ConversionFilesBuilder conversionFiles(final List<ConversionFile> conversionFiles) {
		this.conversionFiles = conversionFiles;
		return this;
	}

	public ConversionFiles build() {
		return new ConversionFilesImpl(this);
	}
}
