package de.mklinger.qetch.client.model.v1.builder;

import java.util.ArrayList;
import java.util.List;

import de.mklinger.qetch.client.model.v1.Availability;
import de.mklinger.qetch.client.model.v1.AvailableConversion;
import de.mklinger.qetch.client.model.v1.Conversion;
import de.mklinger.qetch.client.model.v1.impl.AvailableConversionImpl;

/**
 * Created by Marius Heinzmann on 3/26/18.
 *
 * @author Marius Heinzmann - mheinzmann[at]mklinger[dot]de
 */
public class AvailableConversionBuilder {
	private List<Availability> availabilities;
	private Conversion conversion;

	public static AvailableConversionBuilder of(final AvailableConversion nodesConversion) {
		return new AvailableConversionBuilder()
				.conversion(nodesConversion.getConversion())
				.availabilities(nodesConversion.getAvailabilities());
	}

	public AvailableConversionBuilder conversion(final Conversion conversion) {
		this.conversion = conversion;
		return this;
	}

	public AvailableConversionBuilder availabilities(final List<Availability> availabilities) {
		if (availabilities == null) {
			this.availabilities = availabilities;
		} else {
			this.availabilities = new ArrayList<>(availabilities);
		}
		return this;
	}

	public AvailableConversionBuilder withAvailability(final Availability availabilitiy) {
		if (availabilities == null) {
			availabilities = new ArrayList<>();
			availabilities.add(availabilitiy);
		} else {
			boolean found = false;
			for (final Availability existingAvailibility : availabilities) {
				if (existingAvailibility.getConverterId().equals(availabilitiy.getNodeId())
						&& existingAvailibility.getNodeId().equals(availabilitiy.getNodeId())) {
					found = true;
				}
			}
			if (!found) {
				availabilities.add(availabilitiy);
			}
		}
		return this;
	}

	public AvailableConversionBuilder withoutAvailabilities() {
		return availabilities(null);
	}

	public AvailableConversion build() {
		return new AvailableConversionImpl(this);
	}

	public List<Availability> getAvailabilities() {
		return availabilities;
	}

	public Conversion getConversion() {
		return conversion;
	}
}
