package de.mklinger.qetch.client.model.v1.builder;

import de.mklinger.qetch.client.model.v1.Availability;
import de.mklinger.qetch.client.model.v1.impl.AvailabilityImpl;

/**
 * Created by Marius Heinzmann on 3/26/18.
 *
 * @author Marius Heinzmann - mheinzmann[at]mklinger[dot]de
 */
public class AvailabilityBuilder {
	private String nodeId;
	private String converterId;

	public static AvailabilityBuilder of(final Availability availability) {
		return new AvailabilityBuilder()
				.nodeId(availability.getNodeId())
				.converterId(availability.getConverterId());
	}

	public AvailabilityBuilder nodeId(final String nodeId) {
		this.nodeId = nodeId;
		return this;
	}

	public AvailabilityBuilder converterId(final String converterId) {
		this.converterId = converterId;
		return this;
	}

	public Availability build() {
		return new AvailabilityImpl(this);
	}

	public String getNodeId() {
		return nodeId;
	}

	public String getConverterId() {
		return converterId;
	}
}
