package de.mklinger.qetch.client.impl.lookup;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import de.mklinger.qetch.client.QetchClient;
import de.mklinger.qetch.client.common.concurrent.Delay;

/**
 * @author Marc Klinger - mklinger[at]mklinger[dot]de
 */
public class ScheduledNodesLookup implements AutoCloseable {
	private static final Logger LOG = LoggerFactory.getLogger(ScheduledNodesLookup.class);

	private final QetchClient client;
	private final NodesHolder nodesHolder;
	private final AtomicBoolean closed;

	public ScheduledNodesLookup(final QetchClient client, final NodesHolder nodesHolder) {
		this.client = client;
		this.nodesHolder = nodesHolder;
		this.closed = new AtomicBoolean();
	}

	public void startDelayed() {
		execute(2, 60, TimeUnit.SECONDS);
	}

	private void execute(final long initialDelay, final long delay, final TimeUnit unit) {
		Delay.delayedExecutor(initialDelay, unit).execute(() -> execute(delay, unit));
	}

	private void execute(final long nextDelay, final TimeUnit unit) {
		if (closed.get()) {
			return;
		}

		LOG.info("Doing nodes lookup...");
		client.getAvailableNodes()
		.thenAccept(nodesHolder::setNodes)
		.whenComplete((unused, error) -> {
			if (closed.get()) {
				return;
			}
			if (error != null) {
				LOG.warn("Error on nodes lookup", error);
			} else {
				LOG.info("Nodes lookup successful");
			}
			execute(nextDelay, nextDelay, unit);
		});
	}

	@Override
	public void close() {
		closed.set(true);
	}
}
