package de.mklinger.qetch.client.impl.lookup;

import java.net.URI;
import java.util.List;

import de.mklinger.qetch.client.model.v1.AvailableNode;
import de.mklinger.qetch.client.model.v1.NodeAddress;

/**
 * @author Marc Klinger - mklinger[at]mklinger[dot]de
 */
public class DynamicServiceUriSupplier extends StaticServiceUriSupplier {
	private final NodesHolder nodesHolder;

	public DynamicServiceUriSupplier(final List<URI> initialServiceUris) {
		super(initialServiceUris);
		this.nodesHolder = new NodesHolder();
	}

	public NodesHolder getNodesHolder() {
		return nodesHolder;
	}

	@Override
	public URI get() {
		return nodesHolder.getRandomNode()
				.map(AvailableNode::getAddress)
				.map(this::toHttpsUriString)
				.map(URI::create)
				.orElseGet(super::get);
	}

	private String toHttpsUriString(final NodeAddress nodeAddress) {
		return "https://" + nodeAddress.toUriString();
	}
}
