package de.mklinger.qetch.client.impl;

import de.mklinger.qetch.client.InputConversionFile;
import de.mklinger.qetch.client.InputJob;
import de.mklinger.qetch.client.QetchClient;
import de.mklinger.qetch.client.impl.lookup.NodeLookupQetchClientImpl;
import de.mklinger.qetch.client.impl.lookup.StaticServiceUriSupplier;
import de.mklinger.qetch.client.impl.retry.RetryingQetchClientImpl;

/**
 * @author Marc Klinger - mklinger[at]mklinger[dot]de
 */
public class InstanceFactory {
	public static QetchClient newInstance(final QetchClientBuilderImpl builder) {
		if (builder.isServiceLookupDisabled()) {
			return new RetryingQetchClientImpl(builder, new StaticServiceUriSupplier(builder.getServiceUris()));
		} else {
			return new NodeLookupQetchClientImpl(builder);
		}
	}

	public static InputConversionFile newInstance(final InputConversionFileBuilderImpl builder) {
		return new InputConversionFileImpl(builder);
	}

	public static InputJob newInstance(final InputJobBuilderImpl builder) {
		return new InputJobImpl(builder);
	}
}
