package de.mklinger.qetch.client.impl;

import java.time.Duration;
import java.util.Objects;

import de.mklinger.commons.httpclient.HttpRequest.BodyProvider;
import de.mklinger.qetch.client.InputConversionFile;
import de.mklinger.qetch.client.common.MediaType;

public class InputConversionFileImpl implements InputConversionFile {
	private final BodyProvider bodyProvider;
	private final MediaType mediaType;
	private final String filename;
	private final Duration deleteTimeout;

	public InputConversionFileImpl(final InputConversionFileBuilderImpl builder) {
		this.bodyProvider = Objects.requireNonNull(builder.getBodyProvider(), "Missing bodyProvider");
		this.mediaType = Objects.requireNonNull(builder.getMediaType(), "Missing mediaType");
		this.filename = builder.getFilename();
		this.deleteTimeout = builder.getDeleteTimeout();
	}

	@Override
	public BodyProvider getBodyProvider() {
		return bodyProvider;
	}

	@Override
	public MediaType getMediaType() {
		return mediaType;
	}

	@Override
	public String getFilename() {
		return filename;
	}

	@Override
	public Duration getDeleteTimeout() {
		return deleteTimeout;
	}
}
