package de.mklinger.qetch.client.common;

/**
 * @author Marc Klinger - mklinger[at]mklinger[dot]de
 */
public class QetchException extends RuntimeException {
	private static final long serialVersionUID = 1L;

	/**
	 * Create a new Qetch exception. If last parameter is a {@link Throwable},
	 * it will we used as cause.
	 */
	public QetchException(final String msg, final Object... args) {
		super(format(msg, args), getCause(args));
	}

	private static String format(final String msg, final Object... args) {
		return LoggerMessageFormat.format(msg, args);
	}

	private static Throwable getCause(final Object[] args) {
		if (args.length > 0 && args[args.length - 1] instanceof Throwable) {
			return (Throwable) args[args.length - 1];
		}
		return null;
	}
}
