package de.mklinger.qetch.client;

import java.io.File;
import java.nio.file.Path;

import de.mklinger.commons.httpclient.BodyProviders;
import de.mklinger.qetch.client.impl.InputConversionFileBuilderImpl;
import de.mklinger.qetch.client.impl.InputJobBuilderImpl;
import de.mklinger.qetch.client.impl.QetchClientBuilderImpl;

/**
 * @author Marc Klinger - mklinger[at]mklinger[dot]de
 */
public class QetchClientBuilders {
	public static QetchClient.Builder client() {
		return new QetchClientBuilderImpl();
	}

	public static InputConversionFile.Builder inputFile() {
		return new InputConversionFileBuilderImpl();
	}

	public static InputConversionFile.Builder inputFileFor(final File inputFile) {
		return inputFileFor(inputFile.toPath());
	}

	public static InputConversionFile.Builder inputFileFor(final Path inputFile) {
		return new InputConversionFileBuilderImpl()
				.filename(inputFile.getFileName().toString())
				.bodyProvider(BodyProviders.fromFile(inputFile));
	}

	public static InputJob.Builder job() {
		return new InputJobBuilderImpl();
	}
}
