package de.mklinger.qetch.client;

import java.time.Duration;

import de.mklinger.commons.httpclient.HttpRequest.BodyProvider;
import de.mklinger.qetch.client.common.MediaType;

/**
 * @author Marc Klinger - mklinger[at]mklinger[dot]de
 */
public interface InputConversionFile {
	BodyProvider getBodyProvider();
	MediaType getMediaType();
	String getFilename();
	Duration getDeleteTimeout();

	public interface Builder {
		Builder filename(String filename);
		Builder mediaType(MediaType mediaType);
		Builder bodyProvider(BodyProvider bodyProvider);
		Builder deleteTimeout(Duration deleteTimeout);
		InputConversionFile build();
	}
}
