/*
 * Decompiled with CFR 0.152.
 */
package de.mklinger.qetcher.client.jetty.http2.client.http;

import de.mklinger.qetcher.client.jetty.client.HttpChannel;
import de.mklinger.qetcher.client.jetty.client.HttpConnection;
import de.mklinger.qetcher.client.jetty.client.HttpDestination;
import de.mklinger.qetcher.client.jetty.client.HttpExchange;
import de.mklinger.qetcher.client.jetty.client.HttpRequest;
import de.mklinger.qetcher.client.jetty.client.SendFailure;
import de.mklinger.qetcher.client.jetty.http.HttpVersion;
import de.mklinger.qetcher.client.jetty.http2.ErrorCode;
import de.mklinger.qetcher.client.jetty.http2.IStream;
import de.mklinger.qetcher.client.jetty.http2.api.Session;
import de.mklinger.qetcher.client.jetty.http2.client.http.HttpChannelOverHTTP2;
import de.mklinger.qetcher.client.jetty.util.Callback;
import de.mklinger.qetcher.client.jetty.util.log.Log;
import de.mklinger.qetcher.client.jetty.util.log.Logger;
import de.mklinger.qetcher.client.jetty.util.thread.Sweeper;
import java.nio.channels.AsynchronousCloseException;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;

public class HttpConnectionOverHTTP2
extends HttpConnection
implements Sweeper.Sweepable {
    private static final Logger LOG = Log.getLogger(HttpConnection.class);
    private final Set<HttpChannel> activeChannels = ConcurrentHashMap.newKeySet();
    private final Queue<HttpChannelOverHTTP2> idleChannels = new ConcurrentLinkedQueue<HttpChannelOverHTTP2>();
    private final AtomicBoolean closed = new AtomicBoolean();
    private final AtomicInteger sweeps = new AtomicInteger();
    private final Session session;
    private boolean recycleHttpChannels;

    public HttpConnectionOverHTTP2(HttpDestination destination, Session session) {
        super(destination);
        this.session = session;
    }

    public Session getSession() {
        return this.session;
    }

    public boolean isRecycleHttpChannels() {
        return this.recycleHttpChannels;
    }

    public void setRecycleHttpChannels(boolean recycleHttpChannels) {
        this.recycleHttpChannels = recycleHttpChannels;
    }

    @Override
    protected SendFailure send(HttpExchange exchange) {
        HttpRequest request = exchange.getRequest();
        request.version(HttpVersion.HTTP_2);
        this.normalizeRequest(request);
        HttpChannelOverHTTP2 channel = this.acquireHttpChannel();
        this.activeChannels.add(channel);
        return this.send(channel, exchange);
    }

    protected HttpChannelOverHTTP2 acquireHttpChannel() {
        HttpChannelOverHTTP2 channel = this.idleChannels.poll();
        if (channel == null) {
            channel = this.newHttpChannel();
        }
        return channel;
    }

    protected HttpChannelOverHTTP2 newHttpChannel() {
        return new HttpChannelOverHTTP2(this.getHttpDestination(), this, this.getSession());
    }

    protected void release(HttpChannelOverHTTP2 channel) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Released {}", channel);
        }
        if (this.activeChannels.remove(channel)) {
            if (channel.isFailed()) {
                channel.destroy();
            } else if (this.isRecycleHttpChannels()) {
                this.idleChannels.offer(channel);
            }
        } else {
            channel.destroy();
        }
    }

    void onStreamClosed(IStream stream, HttpChannelOverHTTP2 channel) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("{} closed for {}", stream, channel);
        }
        channel.setStream(null);
        if (stream.isLocal()) {
            this.getHttpDestination().release(this);
        }
    }

    @Override
    public boolean onIdleTimeout(long idleTimeout) {
        boolean close = super.onIdleTimeout(idleTimeout);
        if (close) {
            this.close(new TimeoutException("idle_timeout"));
        }
        return false;
    }

    @Override
    public void close() {
        this.close(new AsynchronousCloseException());
    }

    protected void close(Throwable failure) {
        if (this.closed.compareAndSet(false, true)) {
            this.getHttpDestination().close(this);
            this.abort(failure);
            this.session.close(ErrorCode.NO_ERROR.code, failure.getMessage(), Callback.NOOP);
            HttpChannel channel = this.idleChannels.poll();
            while (channel != null) {
                channel.destroy();
                channel = this.idleChannels.poll();
            }
        }
    }

    @Override
    public boolean isClosed() {
        return this.closed.get();
    }

    private void abort(Throwable failure) {
        for (HttpChannel channel : this.activeChannels) {
            HttpExchange exchange = channel.getHttpExchange();
            if (exchange == null) continue;
            exchange.getRequest().abort(failure);
        }
        this.activeChannels.clear();
        HttpChannel channel = this.idleChannels.poll();
        while (channel != null) {
            channel.destroy();
            channel = this.idleChannels.poll();
        }
    }

    @Override
    public boolean sweep() {
        if (!this.isClosed()) {
            return false;
        }
        return this.sweeps.incrementAndGet() >= 4;
    }

    @Override
    public String toString() {
        return String.format("%s@%x(closed=%b)[%s]", this.getClass().getSimpleName(), this.hashCode(), this.isClosed(), this.session);
    }
}

