/*
 * Decompiled with CFR 0.152.
 */
package de.mklinger.qetcher.client.deps.jetty.http2.generator;

import de.mklinger.qetcher.client.deps.jetty.http2.frames.Frame;
import de.mklinger.qetcher.client.deps.jetty.http2.frames.FrameType;
import de.mklinger.qetcher.client.deps.jetty.http2.frames.WindowUpdateFrame;
import de.mklinger.qetcher.client.deps.jetty.http2.generator.FrameGenerator;
import de.mklinger.qetcher.client.deps.jetty.http2.generator.HeaderGenerator;
import de.mklinger.qetcher.client.deps.jetty.io.ByteBufferPool;
import de.mklinger.qetcher.client.deps.jetty.util.BufferUtil;
import java.nio.ByteBuffer;

public class WindowUpdateGenerator
extends FrameGenerator {
    public WindowUpdateGenerator(HeaderGenerator headerGenerator) {
        super(headerGenerator);
    }

    @Override
    public int generate(ByteBufferPool.Lease lease, Frame frame) {
        WindowUpdateFrame windowUpdateFrame = (WindowUpdateFrame)frame;
        return this.generateWindowUpdate(lease, windowUpdateFrame.getStreamId(), windowUpdateFrame.getWindowDelta());
    }

    public int generateWindowUpdate(ByteBufferPool.Lease lease, int streamId, int windowUpdate) {
        if (windowUpdate < 0) {
            throw new IllegalArgumentException("Invalid window update: " + windowUpdate);
        }
        ByteBuffer header = this.generateHeader(lease, FrameType.WINDOW_UPDATE, 4, 0, streamId);
        header.putInt(windowUpdate);
        BufferUtil.flipToFlush(header, 0);
        lease.append(header, true);
        return 13;
    }
}

