/*
 * Decompiled with CFR 0.152.
 */
package de.mklinger.qetch.client.model.v1.impl;

import de.mklinger.qetch.client.model.v1.NodeAddress;
import de.mklinger.qetch.client.model.v1.builder.NodeAddressBuilder;

public final class NodeAddressImpl
implements NodeAddress {
    private final String host;
    private final int port;

    private NodeAddressImpl(String host, int port) {
        if (host == null || host.isEmpty()) {
            throw new IllegalArgumentException("Host is required");
        }
        if (port <= 0) {
            throw new IllegalArgumentException("Port must be > 0");
        }
        this.host = host;
        this.port = port;
    }

    public NodeAddressImpl(NodeAddressBuilder builder) {
        this(builder.getHost(), builder.getPort());
    }

    @Override
    public int getPort() {
        return this.port;
    }

    @Override
    public String getHost() {
        return this.host;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.host == null ? 0 : this.host.hashCode());
        result = 31 * result + this.port;
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        NodeAddressImpl other = (NodeAddressImpl)obj;
        if (this.host == null ? other.host != null : !this.host.equals(other.host)) {
            return false;
        }
        return this.port == other.port;
    }

    public String toString() {
        return this.toUriString();
    }

    @Override
    public String toUriString() {
        return this.toHostUriString() + ":" + this.port;
    }

    @Override
    public String toHostUriString() {
        if (this.host.contains(":")) {
            return "[" + this.host + "]";
        }
        return this.host;
    }
}

