/*
 * Decompiled with CFR 0.152.
 */
package de.mklinger.qetch.client.model.v1.builder;

import de.mklinger.qetch.client.model.v1.Availability;
import de.mklinger.qetch.client.model.v1.AvailableConversion;
import de.mklinger.qetch.client.model.v1.Conversion;
import de.mklinger.qetch.client.model.v1.impl.AvailableConversionImpl;
import java.util.ArrayList;
import java.util.List;

public class AvailableConversionBuilder {
    private List<Availability> availabilities;
    private Conversion conversion;

    public static AvailableConversionBuilder of(AvailableConversion nodesConversion) {
        return new AvailableConversionBuilder().conversion(nodesConversion.getConversion()).availabilities(nodesConversion.getAvailabilities());
    }

    public AvailableConversionBuilder conversion(Conversion conversion) {
        this.conversion = conversion;
        return this;
    }

    public AvailableConversionBuilder availabilities(List<Availability> availabilities) {
        this.availabilities = availabilities == null ? availabilities : new ArrayList<Availability>(availabilities);
        return this;
    }

    public AvailableConversionBuilder withAvailability(Availability availabilitiy) {
        if (this.availabilities == null) {
            this.availabilities = new ArrayList<Availability>();
            this.availabilities.add(availabilitiy);
        } else {
            boolean found = false;
            for (Availability existingAvailibility : this.availabilities) {
                if (!existingAvailibility.getConverterId().equals(availabilitiy.getNodeId()) || !existingAvailibility.getNodeId().equals(availabilitiy.getNodeId())) continue;
                found = true;
            }
            if (!found) {
                this.availabilities.add(availabilitiy);
            }
        }
        return this;
    }

    public AvailableConversionBuilder withoutAvailabilities() {
        return this.availabilities(null);
    }

    public AvailableConversion build() {
        return new AvailableConversionImpl(this);
    }

    public List<Availability> getAvailabilities() {
        return this.availabilities;
    }

    public Conversion getConversion() {
        return this.conversion;
    }
}

