/*
 * Decompiled with CFR 0.152.
 */
package de.mklinger.qetch.client.impl.lookup;

import de.mklinger.qetch.client.model.v1.AvailableNode;
import de.mklinger.qetch.client.model.v1.NodeLifecycle;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NodesHolder {
    private static final Logger LOG = LoggerFactory.getLogger(NodesHolder.class);
    private final AtomicReference<List<AvailableNode>> fullyFunctionalNodes = new AtomicReference(Collections.emptyList());
    private final AtomicReference<List<AvailableNode>> otherNodes = new AtomicReference(Collections.emptyList());

    public void setNodes(List<AvailableNode> availableNodes) {
        this.fullyFunctionalNodes.set(availableNodes.stream().filter(this::isFullyFunctionalNode).collect(Collectors.toList()));
        this.otherNodes.set(availableNodes.stream().filter(this::isOtherNode).collect(Collectors.toList()));
    }

    private boolean isFullyFunctionalNode(AvailableNode node) {
        return node.getNodeLifecycle() == NodeLifecycle.FULLY_FUNCTIONAL;
    }

    private boolean isOtherNode(AvailableNode node) {
        return !this.isFullyFunctionalNode(node);
    }

    public List<AvailableNode> getNodes() {
        List<AvailableNode> currentFullyFunctionalNodes = this.fullyFunctionalNodes.get();
        List<AvailableNode> currentOtherNodes = this.otherNodes.get();
        ArrayList<AvailableNode> availableNodes = new ArrayList<AvailableNode>(currentFullyFunctionalNodes.size() + currentOtherNodes.size());
        availableNodes.addAll(currentFullyFunctionalNodes);
        availableNodes.addAll(currentOtherNodes);
        return availableNodes;
    }

    public Optional<AvailableNode> getRandomNode() {
        List<AvailableNode> currentFullyFunctionalNodes = this.fullyFunctionalNodes.get();
        List<AvailableNode> currentOtherNodes = this.otherNodes.get();
        Optional<AvailableNode> node = this.getRandomNode(currentFullyFunctionalNodes);
        if (!node.isPresent()) {
            node = this.getRandomNode(currentOtherNodes);
        }
        if (LOG.isDebugEnabled() && node.isPresent()) {
            LOG.debug("Choosing node {} at {} ({})", new Object[]{node.get().getNodeName(), node.get().getAddress().toUriString(), node.get().getNodeLifecycle()});
        }
        return node;
    }

    private Optional<AvailableNode> getRandomNode(List<AvailableNode> nodes) {
        if (nodes.isEmpty()) {
            return Optional.empty();
        }
        int randomIdx = ThreadLocalRandom.current().nextInt(nodes.size());
        return Optional.of(nodes.get(randomIdx));
    }
}

