/*
 * Decompiled with CFR 0.152.
 */
package de.mklinger.qetch.client.impl.lookup;

import de.mklinger.qetch.client.impl.lookup.NodesHolder;
import de.mklinger.qetch.client.impl.lookup.StaticServiceUriSupplier;
import de.mklinger.qetch.client.model.v1.AvailableNode;
import de.mklinger.qetch.client.model.v1.NodeAddress;
import java.net.URI;
import java.util.List;

public class DynamicServiceUriSupplier
extends StaticServiceUriSupplier {
    private final NodesHolder nodesHolder = new NodesHolder();

    public DynamicServiceUriSupplier(List<URI> initialServiceUris) {
        super(initialServiceUris);
    }

    public NodesHolder getNodesHolder() {
        return this.nodesHolder;
    }

    @Override
    public URI get() {
        return this.nodesHolder.getRandomNode().map(AvailableNode::getAddress).map(this::toHttpsUriString).map(URI::create).orElseGet(() -> super.get());
    }

    private String toHttpsUriString(NodeAddress nodeAddress) {
        return "https://" + nodeAddress.toUriString();
    }
}

