/*
 * Decompiled with CFR 0.152.
 */
package de.mklinger.qetch.client.impl;

import de.mklinger.qetch.client.InputConversionFile;
import de.mklinger.qetch.client.InputJob;
import de.mklinger.qetch.client.common.MediaType;
import de.mklinger.qetch.client.impl.InstanceFactory;
import de.mklinger.qetch.client.model.v1.ConversionFile;
import java.time.Duration;

public class InputJobBuilderImpl
implements InputJob.Builder {
    private String conversionFileId;
    private InputConversionFile inputConversionFile;
    private MediaType fromMediaType;
    private MediaType toMediaType;
    private Duration deleteTimeout;
    private Duration cancelTimeout;
    private String referrer;

    @Override
    public InputJob.Builder fromFile(String conversionFileId) {
        this.conversionFileId = conversionFileId;
        return this;
    }

    @Override
    public InputJob.Builder fromFile(ConversionFile conversionFile) {
        this.conversionFileId = conversionFile.getFileId();
        return this;
    }

    public String getConversionFileId() {
        return this.conversionFileId;
    }

    @Override
    public InputJob.Builder fromFile(InputConversionFile inputConversionFile) {
        this.inputConversionFile = inputConversionFile;
        return this;
    }

    public InputConversionFile getInputConversionFile() {
        return this.inputConversionFile;
    }

    @Override
    public InputJob.Builder fromMediaType(MediaType mediaType) {
        this.fromMediaType = mediaType;
        return this;
    }

    public MediaType getFromMediaType() {
        return this.fromMediaType;
    }

    @Override
    public InputJob.Builder toMediaType(MediaType mediaType) {
        this.toMediaType = mediaType;
        return this;
    }

    public MediaType getToMediaType() {
        return this.toMediaType;
    }

    @Override
    public InputJob.Builder deleteTimeout(Duration deleteTimeout) {
        this.deleteTimeout = deleteTimeout;
        return this;
    }

    public Duration getDeleteTimeout() {
        return this.deleteTimeout;
    }

    @Override
    public InputJob.Builder cancelTimeout(Duration cancelTimeout) {
        this.cancelTimeout = cancelTimeout;
        return this;
    }

    public Duration getCancelTimeout() {
        return this.cancelTimeout;
    }

    @Override
    public InputJob.Builder referrer(String referrer) {
        this.referrer = referrer;
        return this;
    }

    public String getReferrer() {
        return this.referrer;
    }

    @Override
    public InputJob build() {
        return InstanceFactory.newInstance(this);
    }
}

