/*
 * Decompiled with CFR 0.152.
 */
package de.mklinger.qetch.client.common.concurrent;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.BiConsumer;
import java.util.function.Supplier;

public class Delay {
    private static final boolean USE_COMMON_POOL = ForkJoinPool.getCommonPoolParallelism() > 1;
    private static final Executor ASYNC_POOL = USE_COMMON_POOL ? ForkJoinPool.commonPool() : new ThreadPerTaskExecutor();

    public static Executor delayedExecutor(long delay, TimeUnit unit) {
        if (unit == null) {
            throw new NullPointerException();
        }
        return new DelayedExecutor(delay, unit, ASYNC_POOL);
    }

    public static <T> CompletableFuture<T> timeout(CompletableFuture<T> cf, long timeout, TimeUnit unit, Supplier<TimeoutException> s) {
        if (unit == null) {
            throw new NullPointerException();
        }
        if (!cf.isDone()) {
            cf.whenComplete((BiConsumer)new Canceller(Delayer.delay(new Timeout(cf, s), timeout, unit)));
        }
        return cf;
    }

    private static final class Timeout
    implements Runnable {
        final CompletableFuture<?> f;
        final Supplier<TimeoutException> s;

        Timeout(CompletableFuture<?> f, Supplier<TimeoutException> s) {
            this.f = f;
            this.s = s;
        }

        @Override
        public void run() {
            if (this.f != null && !this.f.isDone()) {
                this.f.completeExceptionally(this.s.get());
            }
        }
    }

    private static final class Canceller
    implements BiConsumer<Object, Throwable> {
        final Future<?> f;

        Canceller(Future<?> f) {
            this.f = f;
        }

        @Override
        public void accept(Object ignore, Throwable ex) {
            if (ex == null && this.f != null && !this.f.isDone()) {
                this.f.cancel(false);
            }
        }
    }

    private static final class TaskSubmitter
    implements Runnable {
        final Executor executor;
        final Runnable action;

        TaskSubmitter(Executor executor, Runnable action) {
            this.executor = executor;
            this.action = action;
        }

        @Override
        public void run() {
            this.executor.execute(this.action);
        }
    }

    private static final class DelayedExecutor
    implements Executor {
        final long delay;
        final TimeUnit unit;
        final Executor executor;

        DelayedExecutor(long delay, TimeUnit unit, Executor executor) {
            this.delay = delay;
            this.unit = unit;
            this.executor = executor;
        }

        @Override
        public void execute(Runnable r) {
            Delayer.delay(new TaskSubmitter(this.executor, r), this.delay, this.unit);
        }
    }

    private static final class Delayer {
        static final ScheduledThreadPoolExecutor delayer = new ScheduledThreadPoolExecutor(1, new DaemonThreadFactory());

        private Delayer() {
        }

        static ScheduledFuture<?> delay(Runnable command, long delay, TimeUnit unit) {
            return delayer.schedule(command, delay, unit);
        }

        static {
            delayer.setRemoveOnCancelPolicy(true);
        }

        static final class DaemonThreadFactory
        implements ThreadFactory {
            DaemonThreadFactory() {
            }

            @Override
            public Thread newThread(Runnable r) {
                Thread t = new Thread(r);
                t.setDaemon(true);
                t.setName("CompletableFutureDelayScheduler");
                return t;
            }
        }
    }

    private static final class ThreadPerTaskExecutor
    implements Executor {
        private ThreadPerTaskExecutor() {
        }

        @Override
        public void execute(Runnable r) {
            new Thread(r).start();
        }
    }
}

