/*
 * Decompiled with CFR 0.152.
 */
package de.mklinger.qetch.client.common;

import de.mklinger.qetch.client.common.QetchException;
import de.mklinger.qetch.client.common.annotations.Nullable;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.util.Objects;

public class KeyStores {
    private static final String CLASSPATH_PREFIX = "classpath:";

    private KeyStores() {
    }

    public static KeyStore load(String location, @Nullable String password) {
        return KeyStores.load(location, password, KeyStore.getDefaultType(), KeyStores.getDefaultClassLoader());
    }

    public static KeyStore load(String location, @Nullable String password, ClassLoader classLoader) {
        return KeyStores.load(location, password, KeyStore.getDefaultType(), classLoader);
    }

    public static KeyStore load(String location, @Nullable String password, String type) {
        return KeyStores.load(location, password, type, KeyStores.getDefaultClassLoader());
    }

    private static ClassLoader getDefaultClassLoader() {
        return KeyStores.class.getClassLoader();
    }

    public static KeyStore load(String location, @Nullable String password, String type, ClassLoader classLoader) {
        Objects.requireNonNull(location);
        Objects.requireNonNull(type);
        Objects.requireNonNull(classLoader);
        try {
            KeyStore keyStore = KeyStore.getInstance(type);
            try (InputStream in = KeyStores.newInputStream(location, classLoader);){
                keyStore.load(in, KeyStores.toCharArray(password));
            }
            return keyStore;
        }
        catch (IOException | KeyStoreException | NoSuchAlgorithmException | CertificateException e) {
            throw new QetchException("Error loading keystore from location '{}'", location, e);
        }
    }

    private static InputStream newInputStream(String location, ClassLoader classLoader) throws IOException {
        if (location.startsWith(CLASSPATH_PREFIX)) {
            String classpathLocation = location.substring(CLASSPATH_PREFIX.length());
            InputStream in = classLoader.getResourceAsStream(classpathLocation);
            if (in == null) {
                in = Thread.currentThread().getContextClassLoader().getResourceAsStream(classpathLocation);
            }
            if (in == null) {
                throw new FileNotFoundException("Classpath resource not found: " + classpathLocation);
            }
            return in;
        }
        if (location.startsWith("/") || location.startsWith("./")) {
            return new FileInputStream(location);
        }
        return URI.create(location).toURL().openStream();
    }

    private static char[] toCharArray(String password) {
        if (password == null) {
            return null;
        }
        return password.toCharArray();
    }
}

