package de.mklinger.qetch.client.model.v1.impl;

import de.mklinger.qetch.client.model.v1.Error;
import de.mklinger.qetch.client.model.v1.builder.ErrorBuilder;

/**
 * @author Marc Klinger - mklinger[at]mklinger[dot]de
 */
public class ErrorImpl implements Error {
	private final String status;
	private final String message;
	private final String errorId;

	public ErrorImpl(final ErrorBuilder builder) {
		this.status = builder.getStatus();
		this.message = builder.getMessage();
		this.errorId = builder.getErrorId();
	}

	@Override
	public String getStatus() {
		return status;
	}

	@Override
	public String getMessage() {
		return message;
	}

	@Override
	public String getErrorId() {
		return errorId;
	}

	@Override
	public String toString() {
		return "ErrorImpl ["
				+ (status != null ? "status=" + status + ", " : "")
				+ (message != null ? "message=" + message + ", " : "")
				+ (errorId != null ? "errorId=" + errorId : "")
				+ "]";
	}
}
