package de.mklinger.qetch.client.model.v1.impl;

import java.util.Objects;

import de.mklinger.qetch.client.model.v1.AvailableNode;
import de.mklinger.qetch.client.model.v1.NodeAddress;
import de.mklinger.qetch.client.model.v1.NodeLifecycle;
import de.mklinger.qetch.client.model.v1.builder.AvailableNodeBuilder;

/**
 * A client available node in the cluster.
 *
 * This model class is not used internally, but only in v1 REST service and
 * Qetch client.
 *
 * @author Marc Klinger - mklinger[at]mklinger[dot]de
 */
public class AvailableNodeImpl implements AvailableNode {
	private final String nodeId;
	private final String nodeName;
	private final NodeLifecycle nodeLifecycle;
	private final NodeAddress address;

	public AvailableNodeImpl(final AvailableNodeBuilder builder) {
		this.nodeId = Objects.requireNonNull(builder.getNodeId());
		this.nodeName = Objects.requireNonNull(builder.getNodeName());
		this.nodeLifecycle = Objects.requireNonNull(builder.getNodeLifecycle());
		this.address = Objects.requireNonNull(builder.getAddress());
	}

	@Override
	public String getNodeId() {
		return nodeId;
	}

	@Override
	public String getNodeName() {
		return nodeName;
	}

	@Override
	public NodeLifecycle getNodeLifecycle() {
		return nodeLifecycle;
	}

	@Override
	public NodeAddress getAddress() {
		return address;
	}
}
