package de.mklinger.qetch.client.model.v1.impl;

import java.util.List;
import java.util.Objects;

import de.mklinger.qetch.client.common.Lists;
import de.mklinger.qetch.client.model.v1.Availability;
import de.mklinger.qetch.client.model.v1.AvailableConversion;
import de.mklinger.qetch.client.model.v1.Conversion;
import de.mklinger.qetch.client.model.v1.ModelValidationException;
import de.mklinger.qetch.client.model.v1.builder.AvailableConversionBuilder;

/**
 * @author Marc Klinger - mklinger[at]mklinger[dot]de
 */
public class AvailableConversionImpl implements AvailableConversion {
	private final List<Availability> availabilities;
	private final Conversion conversion;

	public AvailableConversionImpl(final AvailableConversionBuilder builder) {
		this.availabilities = Lists.newImmutableList(builder.getAvailabilities());
		this.conversion = builder.getConversion();

		try {
			validate();
		} catch (final Exception e) {
			throw new ModelValidationException(AvailableConversion.class, e);
		}
	}

	private void validate() {
		Objects.requireNonNull(availabilities);
		if (availabilities.isEmpty()) {
			throw new IllegalArgumentException("Availabilities must not be empty");
		}
		Objects.requireNonNull(conversion);
	}

	@Override
	public List<Availability> getAvailabilities() {
		return availabilities;
	}

	@Override
	public Conversion getConversion() {
		return conversion;
	}

}
